/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;

final class FipsCipherSuitePredicate
extends CipherSuitePredicate {
    static final FipsCipherSuitePredicate TRUE = new FipsCipherSuitePredicate(true);
    static final FipsCipherSuitePredicate FALSE = new FipsCipherSuitePredicate(false);
    private final boolean fips;

    private FipsCipherSuitePredicate(boolean fips) {
        this.fips = fips;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("is ");
        if (!this.fips) {
            b.append("not ");
        }
        b.append("FIPS");
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.fips == entry.isFips();
    }
}

