/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.security.spec.InvalidKeySpecException;
import javax.naming.NamingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Message(id=2, value="Parameter %s is empty")
    public IllegalArgumentException emptyParameter(String var1);

    @Message(id=3, value="This builder has already been built")
    public IllegalStateException builderAlreadyBuilt();

    @Message(id=4, value="Unrecognized algorithm \"%s\"")
    public IllegalArgumentException unrecognizedAlgorithm(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Credential destroying failed")
    public void credentialDestroyingFailed(@Cause Throwable var1);

    @Message(id=1041, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredential();

    @Message(id=1042, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredentialWithCause(@Cause Throwable var1);

    @Message(id=1053, value="Insufficient data to form a digest and a salt")
    public InvalidKeySpecException insufficientDataToFormDigestAndSalt();

    @Message(id=1057, value="No DirContext supplier set")
    public IllegalStateException noDirContextSupplierSet();

    @Message(id=1058, value="No principal mapping definition")
    public IllegalStateException noPrincipalMappingDefinition();

    @Message(id=1060, value="Could not obtain principal")
    public RuntimeException couldNotObtainPrincipal();

    @Message(id=1062, value="No provider URL has been set")
    public IllegalStateException noProviderUrlSet();

    @Message(id=1064, value="Invalid identity name")
    public IllegalArgumentException invalidName();

    @Message(id=1079, value="Ldap-backed realm failed to obtain attributes for entry [%s]")
    public RuntimeException ldapRealmFailedObtainAttributes(String var1, @Cause Throwable var2);

    @Message(id=1080, value="Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].")
    public RuntimeException ldapRealmInvalidRdnForAttribute(String var1, String var2, String var3, @Cause Throwable var4);

    @Message(id=1083, value="Ldap-backed realm cannot to obtain not existing identity \"%s\"")
    public RealmUnavailableException ldapRealmIdentityNotExists(String var1);

    @Message(id=1084, value="Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].")
    public RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(String var1, String var2, String var3, @Cause Throwable var4);

    @Message(id=1085, value="LDAP realm persister does not support given credential type")
    public RealmUnavailableException ldapRealmsPersisterNotSupported();

    @Message(id=1086, value="Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"")
    public RealmUnavailableException ldapRealmCredentialPersistingFailed(String var1, String var2, @Cause Throwable var3);

    @Message(id=1087, value="Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"")
    public RealmUnavailableException ldapRealmCredentialClearingFailed(String var1, @Cause Throwable var2);

    @Message(id=1090, value="Unknown LDAP password scheme")
    public InvalidKeySpecException unknownLdapPasswordScheme();

    @Message(id=1096, value="No such identity")
    public RealmUnavailableException noSuchIdentity();

    @Message(id=1097, value="Ldap-backed realm failed to delete identity from server")
    public RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(@Cause Throwable var1);

    @Message(id=1098, value="Ldap-backed realm failed to create identity on server")
    public RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(@Cause Throwable var1);

    @Message(id=1099, value="Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)")
    public RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities();

    @Message(id=1100, value="Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"")
    public RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1101, value="Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")")
    public void ldapRealmDoesNotSupportSettingFilteredAttribute(String var1, String var2);

    @Message(id=1102, value="Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")")
    public RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(String var1, String var2);

    @Message(id=1103, value="Ldap-backed realm failed to set attributes of identity \"%s\"")
    public RealmUnavailableException ldapRealmAttributesSettingFailed(String var1, @Cause Throwable var2);

    @Message(id=1108, value="Ldap-backed realm identity search failed")
    public RealmUnavailableException ldapRealmIdentitySearchFailed(@Cause Throwable var1);

    @Message(id=1109, value="Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)")
    public RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities();

    @Message(id=1125, value="Ldap-backed realm failed to obtain context")
    public RealmUnavailableException ldapRealmFailedToObtainContext(@Cause Throwable var1);

    @LogMessage
    @Message(id=1146, value="LDAP Realm unable to register listener, defering action.")
    public void ldapRealmDeferRegistration();

    @Message(id=1147, value="Invalid LDAP name [%s]")
    public RuntimeException ldapInvalidLdapName(String var1, @Cause Throwable var2);

    @Message(id=1150, value="Obtaining DirContext credentials from AuthenticationContext failed.")
    public NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(@Cause Throwable var1);

    @Message(id=1153, value="Direct LDAP verification failed with DN [%s] and absolute DN [%s]")
    public RealmUnavailableException directLdapVerificationFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=4025, value="DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting")
    public IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet();
}

