/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.sfbasic;

import java.security.Provider;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.sfbasic.BasicAuthenticationMechanism;
import org.wildfly.security.http.sfbasic.IdentityManager;

public class BasicMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    public static final String STATEFUL_BASIC_NAME = "STATEFUL_BASIC";
    public static final String COOKIE_NAME = "ELYTRON_AUTH_SESSION";
    private final IdentityManager identityManager = new IdentityManager();

    public BasicMechanismFactory() {
    }

    public BasicMechanismFactory(Provider provider) {
    }

    public BasicMechanismFactory(Provider ... providers) {
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        return new String[]{STATEFUL_BASIC_NAME};
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        Assert.checkNotNullParam((String)"properties", properties);
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        if (STATEFUL_BASIC_NAME.equals(mechanismName)) {
            return new BasicAuthenticationMechanism(callbackHandler, this.identityManager, (String)properties.get(HttpConstants.CONFIG_REALM), Boolean.parseBoolean((String)properties.get("silent")), false);
        }
        return null;
    }

    public void shutdown() {
        this.identityManager.shutdown();
    }
}

