/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.dynamic.ssl;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=21000, max=21999)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Message(id=21000, value="DynamicSSLContext creates loop")
    public IllegalStateException dynamicSSLContextCreatesLoop();

    @Message(id=21001, value="Received SSLContext from DynamicSSLContextProvider was null")
    public IllegalStateException receivedSSLContextFromDynamicSSLContextProviderWasNull();

    @Message(id=21002, value="Dynamic SSLContext does not support sessions")
    public UnsupportedOperationException dynamicSSLContextDoesNotSupportSessions();

    @Message(id=21003, value="Provider for DynamicSSLContextSPI threw an exception when getting configured SSLContexts")
    public IllegalStateException unableToGetConfiguredSSLContexts();

    @Message(id=21004, value="Provider for DynamicSSLContextSPI returned null configured SSLContexts")
    public IllegalStateException configuredSSLContextsAreNull();

    @Message(id=21005, value="Cannot obtain default SSLContext from DynamicSSLContext implementation")
    public IllegalStateException cannotObtainConfiguredDefaultSSLContext();

    @Message(id=21006, value="Could not create URI from host and port")
    public IllegalStateException couldNotCreateURI();

    @Message(id=21007, value="Could not create dynamic ssl context engine")
    public IllegalStateException couldNotCreateDynamicSSLContextEngine();

    @Message(id=21008, value="Provider for DynamicSSLContextSPI returned null SSLContext")
    public IllegalStateException configuredSSLContextIsNull();

    @Message(id=21009, value="Obtaining of the default SSLContext from current authentication context resulted in exception.")
    public DynamicSSLContextException cannotObtainDefaultSSLContext(@Cause Throwable var1);

    @Message(id=21010, value="Obtaining of all configured SSLContexts from current authentication context resulted in exception.")
    public DynamicSSLContextException cannotObtainConfiguredSSLContexts(@Cause Throwable var1);

    @Message(id=21011, value="Obtaining of the SSLContext from current authentication context and provided URI resulted in exception.")
    public DynamicSSLContextException cannotObtainSSLContextForGivenURI(@Cause Throwable var1);
}

