/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.spec.InvalidKeySpecException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.util.ElytronMessages2;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.ElytronPermission;

@Deprecated
public final class ElytronAuthenticator
extends Authenticator {
    private static final AuthenticationContextConfigurationClient client = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private static final ElytronPermission CREATE_AUTHENTICATOR_PERMISSION = new ElytronPermission("createAuthenticator");

    public ElytronAuthenticator() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)CREATE_AUTHENTICATOR_PERMISSION);
        }
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        char[] password;
        NameCallback nameCallback;
        block13: {
            AuthenticationConfiguration authenticationConfiguration;
            AuthenticationContext context = AuthenticationContext.captureCurrent();
            try {
                authenticationConfiguration = client.getAuthenticationConfiguration(this.getRequestingURL().toURI(), context);
            }
            catch (URISyntaxException e) {
                ElytronMessages2.log.tracef("URISyntaxException getting URI from the requesting URL [%s]:", this.getRequestingURL(), e);
                return null;
            }
            if (authenticationConfiguration == null) {
                return null;
            }
            CallbackHandler callbackHandler = client.getCallbackHandler(authenticationConfiguration);
            nameCallback = new NameCallback(this.getRequestingPrompt());
            CredentialCallback credentialCallback = new CredentialCallback(PasswordCredential.class);
            password = null;
            try {
                callbackHandler.handle(new Callback[]{nameCallback, credentialCallback});
                TwoWayPassword twoWayPassword = (TwoWayPassword)credentialCallback.applyToCredential(PasswordCredential.class, c -> (TwoWayPassword)c.getPassword().castAs(TwoWayPassword.class));
                if (twoWayPassword == null) {
                    return null;
                }
                PasswordFactory factory = PasswordFactory.getInstance((String)twoWayPassword.getAlgorithm(), client.getProviderSupplier(authenticationConfiguration));
                password = ((ClearPasswordSpec)factory.getKeySpec(factory.translate((Password)twoWayPassword), ClearPasswordSpec.class)).getEncodedPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() != credentialCallback) break block13;
                PasswordCallback passwordCallback = new PasswordCallback("Password", false);
                try {
                    callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
                    password = passwordCallback.getPassword();
                }
                catch (IOException | UnsupportedCallbackException e1) {
                    ElytronMessages2.log.trace("Error handling callback:", e1);
                    return null;
                }
            }
            catch (IOException e) {
                ElytronMessages2.log.trace("IOException handling callback:", e);
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                ElytronMessages2.log.trace("NoSuchAlgorithmException getting PasswordFactory:", e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                ElytronMessages2.log.trace("InvalidKeySpecException getting ClearPasswordSpec:", e);
                return null;
            }
            catch (InvalidKeyException e) {
                ElytronMessages2.log.trace("InvalidKeyException getting ClearPasswordSpec:", e);
                return null;
            }
        }
        String name = nameCallback.getName();
        if (name == null || password == null) {
            return null;
        }
        return new PasswordAuthentication(name, password);
    }
}

