/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.netty.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.function.Supplier;
import org.wildfly.security.auth.server.SecurityIdentity;

class ElytronRunAsHandler
extends ChannelInboundHandlerAdapter {
    private final Supplier<SecurityIdentity> securityIdentitySupplier;

    ElytronRunAsHandler(Supplier<SecurityIdentity> securityIdentitySupplier) {
        this.securityIdentitySupplier = securityIdentitySupplier;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        System.out.println("ElytronRunAsHandler.read()");
        SecurityIdentity securityIdentity = this.securityIdentitySupplier.get();
        if (securityIdentity != null) {
            System.out.println("ElytronRunAsHandler - " + securityIdentity.getPrincipal().getName());
            securityIdentity.runAsFunctionEx(v -> {
                super.channelRead(ctx, msg);
                return null;
            }, null);
        } else {
            System.out.println("ElytronRunAsHandler - No Identity");
            super.channelRead(ctx, msg);
        }
    }
}

