/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.netty.server;

import io.netty.handler.codec.http.HttpRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.netty.server.ElytronResponse;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.Scope;

class ElytronHttpExchange
implements HttpExchangeSpi {
    private final HttpRequest httpRequest;
    private final ElytronResponse elytronResponse;
    private final SocketAddress remoteSocketAddress;
    private volatile SecurityIdentity securityIdentity;

    ElytronHttpExchange(HttpRequest httpRequest, ElytronResponse elytronResponse, SocketAddress remoteSocketAddress) {
        this.httpRequest = (HttpRequest)Assert.checkNotNullParam((String)"httpRequest", (Object)httpRequest);
        this.elytronResponse = (ElytronResponse)Assert.checkNotNullParam((String)"elytronResponse", (Object)elytronResponse);
        this.remoteSocketAddress = remoteSocketAddress;
    }

    public HttpScope getScope(Scope scope) {
        return null;
    }

    public Collection<String> getScopeIds(Scope scope) {
        return null;
    }

    public HttpScope getScope(Scope scope, String id) {
        return null;
    }

    public List<String> getRequestHeaderValues(String headerName) {
        return this.httpRequest.headers().getAll(headerName);
    }

    public String getRequestMethod() {
        return this.httpRequest.method().name();
    }

    public URI getRequestURI() {
        try {
            return new URI(this.httpRequest.uri());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getRequestPath() {
        return this.getRequestURI().getPath();
    }

    public Map<String, List<String>> getRequestParameters() {
        return Collections.emptyMap();
    }

    public List<HttpServerCookie> getCookies() {
        return Collections.emptyList();
    }

    public InputStream getRequestInputStream() {
        return null;
    }

    public InetSocketAddress getSourceAddress() {
        if (this.remoteSocketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)this.remoteSocketAddress;
        }
        return null;
    }

    public void addResponseHeader(String headerName, String headerValue) {
        this.elytronResponse.addHeader(headerName, headerValue);
    }

    public void setStatusCode(int statusCode) {
        this.elytronResponse.setStatusCode(statusCode);
    }

    public void setResponseCookie(HttpServerCookie cookie) {
    }

    public OutputStream getResponseOutputStream() {
        return this.elytronResponse.getOutputStream();
    }

    public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
        this.securityIdentity = securityIdentity;
    }

    public void authenticationFailed(String message, String mechanismName) {
    }

    public void badRequest(HttpAuthenticationException error, String mechanismName) {
    }

    SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }
}

