/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class Utils {
    public static String getBootableJarPath(String jarFileName, MavenProject project, String goal) throws MojoExecutionException {
        String path;
        String jarName = jarFileName;
        if (jarName == null) {
            String finalName = project.getBuild().getFinalName();
            jarName = finalName + "-" + "bootable" + "." + "jar";
        }
        if (!Files.exists(Paths.get(path = project.getBuild().getDirectory() + File.separator + jarName, new String[0]), new LinkOption[0])) {
            throw new MojoExecutionException("Cannot " + goal + " without a bootable jar; please `mvn wildfly-jar:package` prior to invoking wildfly-jar:run from the command-line");
        }
        return path;
    }

    public static Path createTemporaryFile(MavenProject project, String ... paths) throws IOException {
        Path result = Paths.get(project.getBuild().getDirectory(), paths);
        Path parent = result.getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return result;
    }
}

