/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.legacy.version;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.as.controller.ModelVersion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LegacyVersions {
    private static ModelVersion createModelVersion(ModelNode node) {
        return ModelVersion.create((int)LegacyVersions.readVersion(node, "management-major-version"), (int)LegacyVersions.readVersion(node, "management-minor-version"), (int)LegacyVersions.readVersion(node, "management-micro-version"));
    }

    private static int readVersion(ModelNode node, String name) {
        if (!node.hasDefined(name)) {
            return 0;
        }
        return node.get(name).asInt();
    }

    public static void main(String[] args) {
        LegacyVersions.output("wf29");
        LegacyVersions.output("7.4.0");
    }

    private static void output(String version) {
        System.out.println("==== " + version + "====");
        System.out.println(LegacyVersions.getModelVersions(version));
    }

    public static Map<String, ModelVersion> getModelVersions(String testControllerVersion) {
        Map<String, ModelVersion> map;
        block8: {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("legacy-versions/standalone-model-versions-" + testControllerVersion + ".dmr");
            try {
                ModelNode legacyModelVersions = ModelNode.fromStream((InputStream)stream);
                map = legacyModelVersions.get("subsystem").asPropertyList().stream().collect(Collectors.toMap(Property::getName, p -> LegacyVersions.createModelVersion(p.getValue())));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load legacy subsystem version");
                }
            }
            stream.close();
        }
        return map;
    }

    public static ModelVersion getSubsystemModelVersion(String testControllerVersion, String subsystemName) {
        return LegacyVersions.getModelVersions(testControllerVersion).get(subsystemName);
    }
}

