/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.persistence.jipijapa.hibernate7.service;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.function.Function;
import org.hibernate.internal.util.cache.InternalCache;

final class WildFlyCustomInternalCache<K, V>
implements InternalCache<K, V> {
    private final Cache<K, V> cache;

    public WildFlyCustomInternalCache(Cache<K, V> caffeineCache) {
        this.cache = caffeineCache;
    }

    public int heldElementsEstimate() {
        return Math.toIntExact(this.cache.estimatedSize());
    }

    public V get(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.cache.get(key, mappingFunction);
    }
}

