/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.persistence.jipijapa.hibernate7;

import jakarta.enterprise.inject.spi.BeanManager;
import java.util.ArrayList;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.wildfly.persistence.jipijapa.hibernate7.JpaLogger;

public class HibernateExtendedBeanManager
implements ExtendedBeanManager {
    private final BeanManager beanManager;
    private final ArrayList<ExtendedBeanManager.LifecycleListener> lifecycleListeners = new ArrayList();

    public HibernateExtendedBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public void beanManagerIsAvailableForUse() {
        if (this.lifecycleListeners.isEmpty()) {
            throw JpaLogger.JPA_LOGGER.HibernateORMDidNotRegisterLifeCycleListener();
        }
        for (ExtendedBeanManager.LifecycleListener hibernateCallback : this.lifecycleListeners) {
            hibernateCallback.beanManagerInitialized(this.beanManager);
        }
    }

    public void registerLifecycleListener(ExtendedBeanManager.LifecycleListener lifecycleListener) {
        this.lifecycleListeners.add(lifecycleListener);
    }
}

