/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ScheduledThreadPoolService;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolManagementUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolAdd
extends AbstractAddStepHandler {
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.THREAD_FACTORY};
    static final AttributeDefinition[] RW_ATTRIBUTES = new AttributeDefinition[0];
    private final ThreadFactoryResolver threadFactoryResolver;
    private final ServiceName serviceNameBase;
    private final RuntimeCapability<Void> capability;

    public ScheduledThreadPoolAdd(ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase, RuntimeCapability<Void> capability) {
        this.threadFactoryResolver = threadFactoryResolver;
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolManagementUtils.BaseThreadPoolParameters params = ThreadPoolManagementUtils.parseScheduledThreadPoolParameters(context, operation, model);
        ScheduledThreadPoolService service = new ScheduledThreadPoolService(params.getMaxThreads(), params.getKeepAliveTime());
        ThreadPoolManagementUtils.installThreadPoolService(service, params.getName(), this.capability, context.getCurrentAddress(), this.serviceNameBase, params.getThreadFactory(), this.threadFactoryResolver, service.getThreadFactoryInjector(), null, null, null, context.getServiceTarget());
    }

    ServiceName getServiceNameBase() {
        return this.serviceNameBase;
    }

    RuntimeCapability<Void> getCapability() {
        return this.capability;
    }

    ThreadFactoryResolver getThreadFactoryResolver() {
        return this.threadFactoryResolver;
    }
}

