/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public interface ThreadFactoryResolver {
    public ServiceName resolveThreadFactory(String var1, String var2, ServiceName var3, ServiceTarget var4);

    public void releaseThreadFactory(String var1, String var2, ServiceName var3, OperationContext var4);

    public static class SimpleResolver
    extends AbstractThreadFactoryResolver {
        final ServiceName threadFactoryServiceNameBase;

        public SimpleResolver(ServiceName threadFactoryServiceNameBase) {
            this.threadFactoryServiceNameBase = threadFactoryServiceNameBase;
        }

        @Override
        public ServiceName resolveNamedThreadFactory(String threadFactoryName, String threadPoolName, ServiceName threadPoolServiceName) {
            return this.threadFactoryServiceNameBase.append(new String[]{threadFactoryName});
        }
    }

    public static abstract class AbstractThreadFactoryResolver
    implements ThreadFactoryResolver {
        @Override
        public ServiceName resolveThreadFactory(String threadFactoryName, String threadPoolName, ServiceName threadPoolServiceName, ServiceTarget serviceTarget) {
            ServiceName threadFactoryServiceName = threadFactoryName != null ? this.resolveNamedThreadFactory(threadFactoryName, threadPoolName, threadPoolServiceName) : this.resolveDefaultThreadFactory(threadPoolName, threadPoolServiceName, serviceTarget);
            return threadFactoryServiceName;
        }

        @Override
        public void releaseThreadFactory(String threadFactoryName, String threadPoolName, ServiceName threadPoolServiceName, OperationContext context) {
            if (threadFactoryName != null) {
                this.releaseNamedThreadFactory(threadFactoryName, threadPoolName, threadPoolServiceName, context);
            } else {
                this.releaseDefaultThreadFactory(threadPoolServiceName, context);
            }
        }

        protected abstract ServiceName resolveNamedThreadFactory(String var1, String var2, ServiceName var3);

        protected void releaseNamedThreadFactory(String threadFactoryName, String threadPoolName, ServiceName threadPoolServiceName, OperationContext context) {
        }

        private ServiceName resolveDefaultThreadFactory(String threadPoolName, ServiceName threadPoolServiceName, ServiceTarget serviceTarget) {
            ServiceName threadFactoryServiceName = threadPoolServiceName.append(new String[]{"thread-factory"});
            ThreadFactoryService service = new ThreadFactoryService();
            service.setThreadGroupName(this.getThreadGroupName(threadPoolName));
            service.setNamePattern("%G - %t");
            serviceTarget.addService(threadFactoryServiceName, (Service)service).install();
            return threadFactoryServiceName;
        }

        protected String getThreadGroupName(String threadPoolName) {
            return threadPoolName + "-threads";
        }

        private void releaseDefaultThreadFactory(ServiceName threadPoolServiceName, OperationContext context) {
            ServiceName threadFactoryServiceName = threadPoolServiceName.append(new String[]{"thread-factory"});
            context.removeService(threadFactoryServiceName);
        }
    }
}

