/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedExecutorService;
import org.jboss.as.threads.TimeSpec;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadPoolExecutor;

public class ManagedJBossThreadPoolExecutorService
extends ManagedExecutorService
implements BlockingExecutor {
    private final JBossThreadPoolExecutor executor;

    public ManagedJBossThreadPoolExecutorService(JBossThreadPoolExecutor executor) {
        super((ExecutorService)executor);
        this.executor = executor;
    }

    @Override
    protected ExecutorService protectExecutor(ExecutorService executor) {
        return JBossExecutors.protectedBlockingExecutorService((BlockingExecutor)((BlockingExecutor)executor));
    }

    @Override
    void internalShutdown() {
        this.executor.shutdown();
    }

    public int getCoreThreads() {
        return this.executor.getCoreThreads();
    }

    void setCoreThreads(int coreThreads) {
        this.executor.setCoreThreads(coreThreads);
    }

    public boolean isAllowCoreTimeout() {
        return this.executor.isAllowCoreThreadTimeout();
    }

    void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.executor.setAllowCoreThreadTimeout(allowCoreTimeout);
    }

    public boolean isBlocking() {
        return this.executor.isBlocking();
    }

    void setBlocking(boolean blocking) {
        this.executor.setBlocking(blocking);
    }

    public int getMaxThreads() {
        return this.executor.getMaxThreads();
    }

    void setMaxThreads(int maxThreads) {
        this.executor.setMaxThreads(maxThreads);
    }

    public long getKeepAlive() {
        return this.executor.getKeepAliveTime();
    }

    void setKeepAlive(TimeSpec keepAlive) {
        this.executor.setKeepAliveTime(keepAlive.getDuration(), keepAlive.getUnit());
    }

    public int getRejectedCount() {
        return this.executor.getRejectedCount();
    }

    public long getTaskCount() {
        return this.executor.getTaskCount();
    }

    public int getLargestThreadCount() {
        return this.executor.getLargestThreadCount();
    }

    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    public int getCurrentThreadCount() {
        return this.executor.getCurrentThreadCount();
    }

    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getQueueSize() {
        return this.executor.getQueueSize();
    }

    <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.executor.addShutdownListener(shutdownListener, attachment);
    }

    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        this.executor.executeBlocking(task);
    }

    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        this.executor.executeBlocking(task, timeout, unit);
    }

    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        this.executor.executeNonBlocking(task);
    }
}

