/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class ThreadPoolMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final List<AttributeDefinition> metrics;
    private final ServiceName serviceNameBase;

    protected ThreadPoolMetricsHandler(List<AttributeDefinition> metrics, ServiceName serviceNameBase) {
        this.metrics = metrics;
        this.serviceNameBase = serviceNameBase;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (AttributeDefinition metric : this.metrics) {
            registration.registerMetric(metric, (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String attributeName = operation.require("name").asString();
        ServiceController<?> serviceController = this.getService(context, operation);
        Service service = serviceController.getService();
        this.setResult(context, attributeName, service);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected abstract void setResult(OperationContext var1, String var2, Service<?> var3) throws OperationFailedException;

    protected ServiceController<?> getService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ServiceController controller = context.getServiceRegistry(false).getService(this.serviceNameBase.append(new String[]{name}));
        if (controller == null) {
            throw ThreadsLogger.ROOT_LOGGER.threadPoolServiceNotFoundForMetrics(this.serviceNameBase.append(new String[]{name}));
        }
        return controller;
    }
}

