/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.threads.PoolAttributeDefinitions;

class ThreadPoolResourceDescriptionResolver
extends StandardResourceDescriptionResolver {
    private static final Set<String> COMMON_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList(PoolAttributeDefinitions.NAME.getName(), PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.getName(), PoolAttributeDefinitions.CORE_THREADS.getName(), PoolAttributeDefinitions.HANDOFF_EXECUTOR.getName(), PoolAttributeDefinitions.KEEPALIVE_TIME.getName(), PoolAttributeDefinitions.MAX_THREADS.getName(), PoolAttributeDefinitions.QUEUE_LENGTH.getName(), PoolAttributeDefinitions.THREAD_FACTORY.getName(), PoolAttributeDefinitions.ACTIVE_COUNT.getName(), PoolAttributeDefinitions.COMPLETED_TASK_COUNT.getName(), PoolAttributeDefinitions.CURRENT_THREAD_COUNT.getName(), PoolAttributeDefinitions.LARGEST_THREAD_COUNT.getName(), PoolAttributeDefinitions.TASK_COUNT.getName(), PoolAttributeDefinitions.QUEUE_SIZE.getName()));
    private static final String COMMON_PREFIX = "threadpool.common";

    ThreadPoolResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
        super(keyPrefix, bundleBaseName, bundleLoader, true, true);
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        if (COMMON_ATTRIBUTE_NAMES.contains(attributeName)) {
            return bundle.getString(this.getBundleKey(attributeName));
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        if (COMMON_ATTRIBUTE_NAMES.contains(attributeName)) {
            return bundle.getString(this.getVariableBundleKey(new String[]{attributeName}, suffixes));
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        if ("add".equals(operationName) && COMMON_ATTRIBUTE_NAMES.contains(paramName)) {
            return bundle.getString(this.getBundleKey(paramName));
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        if ("add".equals(operationName) && COMMON_ATTRIBUTE_NAMES.contains(paramName)) {
            return bundle.getString(this.getVariableBundleKey(new String[]{paramName}, suffixes));
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
    }

    private String getBundleKey(String ... args) {
        return this.getVariableBundleKey(args, new String[0]);
    }

    private String getVariableBundleKey(String[] fixed, String ... variable) {
        StringBuilder sb = new StringBuilder(COMMON_PREFIX);
        for (String arg : fixed) {
            sb.append('.');
            sb.append(arg);
        }
        if (variable != null) {
            for (String arg : variable) {
                sb.append('.');
                sb.append(arg);
            }
        }
        return sb.toString();
    }
}

