/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.KeepAliveTimeAttributeDefinition;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class ThreadPoolManagementUtils {
    ThreadPoolManagementUtils() {
    }

    static <T> void installThreadPoolService(Service<T> threadPoolService, String threadPoolName, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, Injector<ThreadFactory> threadFactoryInjector, ServiceTarget target, List<ServiceController<?>> newControllers, ServiceListener<Object> ... newServiceListeners) {
        ThreadPoolManagementUtils.installThreadPoolService(threadPoolService, threadPoolName, serviceNameBase, threadFactoryName, threadFactoryResolver, threadFactoryInjector, null, null, null, target, newControllers, newServiceListeners);
    }

    static <T> void installThreadPoolService(Service<T> threadPoolService, String threadPoolName, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, Injector<ThreadFactory> threadFactoryInjector, String handoffExecutorName, HandoffExecutorResolver handoffExecutorResolver, Injector<Executor> handoffExecutorInjector, ServiceTarget target, List<ServiceController<?>> newControllers, ServiceListener<Object> ... newServiceListeners) {
        ServiceName handoffServiceName;
        ServiceName threadPoolServiceName = serviceNameBase.append(new String[]{threadPoolName});
        ServiceBuilder serviceBuilder = target.addService(threadPoolServiceName, threadPoolService);
        ServiceName threadFactoryServiceName = threadFactoryResolver.resolveThreadFactory(threadFactoryName, threadPoolName, threadPoolServiceName, target, newControllers, newServiceListeners);
        serviceBuilder.addDependency(threadFactoryServiceName, ThreadFactory.class, threadFactoryInjector);
        if (handoffExecutorInjector != null && (handoffServiceName = handoffExecutorResolver.resolveHandoffExecutor(handoffExecutorName, threadPoolName, threadPoolServiceName, target, newControllers, newServiceListeners)) != null) {
            serviceBuilder.addDependency(handoffServiceName, Executor.class, handoffExecutorInjector);
        }
        if (newServiceListeners != null && newServiceListeners.length > 0) {
            serviceBuilder.addListener(newServiceListeners);
        }
        ServiceController sc = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }

    static void removeThreadPoolService(String threadPoolName, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, OperationContext operationContext) {
        ThreadPoolManagementUtils.removeThreadPoolService(threadPoolName, serviceNameBase, threadFactoryName, threadFactoryResolver, null, null, operationContext);
    }

    static void removeThreadPoolService(String threadPoolName, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, String handoffExecutorName, HandoffExecutorResolver handoffExecutorResolver, OperationContext operationContext) {
        ServiceName threadPoolServiceName = serviceNameBase.append(new String[]{threadPoolName});
        operationContext.removeService(threadPoolServiceName);
        threadFactoryResolver.releaseThreadFactory(threadFactoryName, threadPoolName, threadPoolServiceName, operationContext);
        if (handoffExecutorResolver != null) {
            handoffExecutorResolver.releaseHandoffExecutor(handoffExecutorName, threadPoolName, threadPoolServiceName, operationContext);
        }
    }

    static BaseThreadPoolParameters parseUnboundedQueueThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        return ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
    }

    static BaseThreadPoolParameters parseScheduledThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        return ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
    }

    static QueuelessThreadPoolParameters parseQueuelessThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model, boolean blocking) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
        if (!blocking) {
            ModelNode handoffEx = PoolAttributeDefinitions.HANDOFF_EXECUTOR.resolveModelAttribute(context, model);
            params.handoffExecutor = handoffEx.isDefined() ? handoffEx.asString() : null;
        }
        return params;
    }

    static BoundedThreadPoolParameters parseBoundedThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model, boolean blocking) throws OperationFailedException {
        ModelNode coreTh;
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
        params.allowCoreTimeout = PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.resolveModelAttribute(context, model).asBoolean();
        if (!blocking) {
            ModelNode handoffEx = PoolAttributeDefinitions.HANDOFF_EXECUTOR.resolveModelAttribute(context, model);
            params.handoffExecutor = handoffEx.isDefined() ? handoffEx.asString() : null;
        }
        params.coreThreads = (coreTh = PoolAttributeDefinitions.CORE_THREADS.resolveModelAttribute(context, model)).isDefined() ? coreTh.asInt() : params.maxThreads;
        params.queueLength = PoolAttributeDefinitions.QUEUE_LENGTH.resolveModelAttribute(context, model).asInt();
        return params;
    }

    private static ThreadPoolParametersImpl parseBaseThreadPoolOperationParameters(OperationContext context, ModelNode operation, ModelNode model, ThreadPoolParametersImpl params) throws OperationFailedException {
        params.address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)params.address);
        params.name = pathAddress.getLastElement().getValue();
        ModelNode tfNode = PoolAttributeDefinitions.THREAD_FACTORY.resolveModelAttribute(context, model);
        params.threadFactory = tfNode.isDefined() ? tfNode.asString() : null;
        params.maxThreads = PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt();
        if (model.hasDefined("keepalive-time")) {
            ModelNode keepaliveTime = model.get("keepalive-time");
            if (!keepaliveTime.hasDefined("time")) {
                throw ThreadsLogger.ROOT_LOGGER.missingKeepAliveTime("time", "keepalive-time");
            }
            if (!keepaliveTime.hasDefined("unit")) {
                throw ThreadsLogger.ROOT_LOGGER.missingKeepAliveUnit("unit", "keepalive-time");
            }
            long time = KeepAliveTimeAttributeDefinition.KEEPALIVE_TIME_TIME.resolveModelAttribute(context, keepaliveTime).asLong();
            String unit = KeepAliveTimeAttributeDefinition.KEEPALIVE_TIME_UNIT.resolveModelAttribute(context, keepaliveTime).asString();
            params.keepAliveTime = new TimeSpec(Enum.valueOf(TimeUnit.class, unit.toUpperCase()), time);
        }
        return params;
    }

    private static class ThreadPoolParametersImpl
    implements QueuelessThreadPoolParameters,
    BoundedThreadPoolParameters {
        ModelNode address;
        String name;
        String threadFactory;
        int maxThreads;
        TimeSpec keepAliveTime;
        String handoffExecutor;
        boolean allowCoreTimeout;
        int coreThreads;
        int queueLength;

        private ThreadPoolParametersImpl() {
        }

        @Override
        public ModelNode getAddress() {
            return this.address;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public int getMaxThreads() {
            return this.maxThreads;
        }

        @Override
        public TimeSpec getKeepAliveTime() {
            return this.keepAliveTime;
        }

        @Override
        public String getHandoffExecutor() {
            return this.handoffExecutor;
        }

        @Override
        public boolean isAllowCoreTimeout() {
            return this.allowCoreTimeout;
        }

        @Override
        public int getCoreThreads() {
            return this.coreThreads;
        }

        @Override
        public int getQueueLength() {
            return this.queueLength;
        }
    }

    static interface BoundedThreadPoolParameters
    extends QueuelessThreadPoolParameters {
        public boolean isAllowCoreTimeout();

        public int getCoreThreads();

        public int getQueueLength();
    }

    static interface QueuelessThreadPoolParameters
    extends BaseThreadPoolParameters {
        public String getHandoffExecutor();
    }

    static interface BaseThreadPoolParameters {
        public ModelNode getAddress();

        public String getName();

        public String getThreadFactory();

        public int getMaxThreads();

        public TimeSpec getKeepAliveTime();
    }
}

