/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.wildfly.common.iteration.CompositeIterable;
import org.wildfly.subsystem.resource.AttributeTranslation;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.AddResourceOperationStepHandlerDescriptor;
import org.wildfly.subsystem.resource.operation.OperationStepHandlerDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.resource.operation.WriteAttributeOperationStepHandler;

public interface ResourceDescriptor
extends AddResourceOperationStepHandlerDescriptor {
    public static Builder builder(ResourceDescriptionResolver resolver) {
        return new DefaultBuilder(resolver);
    }

    public static <T, P extends Supplier<T>> Stream<T> stream(Collection<P> providers) {
        return providers.stream().map(Supplier::get);
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver();

    default public Set<ResourceCapabilityReference<?>> getResourceCapabilityReferences() {
        return Collections.emptySet();
    }

    @Deprecated(forRemoval=true, since="26.0.0")
    default public UnaryOperator<OperationStepHandler> getResourceOperationTransformation() {
        return this.getOperationTransformation("");
    }

    default public UnaryOperator<OperationStepHandler> getOperationTransformation(String operationName) {
        return UnaryOperator.identity();
    }

    default public Iterable<AttributeDefinition> getAttributes() {
        return List.of();
    }

    default public OperationStepHandler getWriteAttributeOperationStepHandler(AttributeDefinition attribute) {
        return null;
    }

    default public Set<RuntimeCapability<?>> getCapabilities() {
        return Set.of();
    }

    @Deprecated(forRemoval=true, since="26.0.0")
    default public UnaryOperator<OperationStepHandler> getAddOperationTransformation() {
        return this.getOperationTransformation("add");
    }

    default public OperationEntry.Flag getAddOperationRestartFlag() {
        return OperationEntry.Flag.RESTART_NONE;
    }

    default public OperationEntry.Flag getRemoveOperationRestartFlag() {
        return OperationEntry.Flag.RESTART_NONE;
    }

    public static class DefaultBuilder
    extends AbstractConfigurator<Builder>
    implements Builder {
        DefaultBuilder(ResourceDescriptionResolver descriptionResolver) {
            super(descriptionResolver);
        }

        @Override
        public ResourceDescriptor build() {
            return new DefaultResourceDescriptor(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class AbstractConfigurator<C extends Configurator<C>>
    implements Configurator<C> {
        static final BiPredicate<OperationContext, Resource> DEFAULT_CAPABILITY_FILTER = (context, resource) -> resource.getModel().isDefined();
        private static final Set<OperationEntry.Flag> RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
        private static final Set<OperationEntry.Flag> RELOAD_RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM);
        private final ResourceDescriptionResolver descriptionResolver;
        private Optional<ResourceOperationRuntimeHandler> runtimeHandler = Optional.empty();
        private OperationEntry.Flag addOperationRestartFlag = OperationEntry.Flag.RESTART_NONE;
        private OperationEntry.Flag removeOperationRestartFlag = OperationEntry.Flag.RESTART_NONE;
        private Map<RuntimeCapability<?>, BiPredicate<OperationContext, Resource>> capabilities = Map.of();
        private Collection<AttributeDefinition> attributes = List.of();
        private Collection<AttributeDefinition> modelOnlyAttributes = List.of();
        private Collection<AttributeDefinition> readOnlyAttributes = List.of();
        private Map<AttributeDefinition, OperationStepHandler> customAttributes = Map.of();
        private Map<PathElement, ResourceRegistration> requiredChildren = Map.of();
        private Map<PathElement, ResourceRegistration> requiredSingletonChildren = Map.of();
        private Map<AttributeDefinition, AttributeTranslation> attributeTranslations = Map.of();
        private Set<ResourceCapabilityReference<?>> resourceCapabilityReferences = Set.of();
        private Map<String, UnaryOperator<OperationStepHandler>> operationTransformers = Map.of();
        private UnaryOperator<OperationStepHandler> defaultOperationTransformer = UnaryOperator.identity();
        private UnaryOperator<Resource> resourceTransformer = UnaryOperator.identity();
        private Optional<Consumer<DeploymentProcessorTarget>> deploymentChainContributor = Optional.empty();

        AbstractConfigurator(ResourceDescriptionResolver descriptionResolver) {
            this.descriptionResolver = descriptionResolver;
        }

        protected abstract C self();

        @Override
        public C withRuntimeHandler(ResourceOperationRuntimeHandler runtimeHandler) {
            this.runtimeHandler = Optional.of(runtimeHandler);
            if (this.removeOperationRestartFlag == OperationEntry.Flag.RESTART_NONE) {
                this.removeOperationRestartFlag = OperationEntry.Flag.RESTART_RESOURCE_SERVICES;
            }
            return this.self();
        }

        @Override
        public C withAddOperationRestartFlag(OperationEntry.Flag restartFlag) {
            if (!RESTART_FLAGS.contains(restartFlag)) {
                throw new IllegalArgumentException(restartFlag.name());
            }
            this.addOperationRestartFlag = restartFlag;
            return this.self();
        }

        @Override
        public C withRemoveOperationRestartFlag(OperationEntry.Flag restartFlag) {
            if (!RESTART_FLAGS.contains(restartFlag)) {
                throw new IllegalArgumentException(restartFlag.name());
            }
            this.removeOperationRestartFlag = restartFlag;
            return this.self();
        }

        @Override
        public C addAttributes(Collection<AttributeDefinition> attributes) {
            this.attributes = this.attributes.isEmpty() ? AbstractConfigurator.copyOf(attributes) : AbstractConfigurator.concat(this.attributes, attributes.stream());
            return this.self();
        }

        @Override
        public C addAttribute(AttributeDefinition attribute, OperationStepHandler writeAttributeHandler) {
            this.customAttributes = AbstractConfigurator.concat(this.customAttributes, attribute, writeAttributeHandler);
            return this.self();
        }

        @Override
        public C addModelOnlyAttributes(Collection<AttributeDefinition> attributes) {
            this.modelOnlyAttributes = this.modelOnlyAttributes.isEmpty() ? AbstractConfigurator.copyOf(attributes) : AbstractConfigurator.concat(this.modelOnlyAttributes, attributes.stream());
            return this.self();
        }

        @Override
        public C addReadOnlyAttributes(Collection<AttributeDefinition> attributes) {
            this.readOnlyAttributes = this.readOnlyAttributes.isEmpty() ? AbstractConfigurator.copyOf(attributes) : AbstractConfigurator.concat(this.readOnlyAttributes, attributes.stream());
            return this.self();
        }

        @Override
        public C translateAttribute(AttributeDefinition attribute, AttributeTranslation translation) {
            assert (attribute.getFlags().contains(AttributeAccess.Flag.ALIAS));
            this.attributeTranslations = AbstractConfigurator.concat(this.attributeTranslations, attribute, translation);
            return this.self();
        }

        @Override
        public C addCapability(RuntimeCapability<?> capability, BiPredicate<OperationContext, Resource> filter) {
            this.capabilities = AbstractConfigurator.concat(this.capabilities, capability, filter);
            return this.self();
        }

        @Override
        public C addCapabilities(Collection<RuntimeCapability<?>> capabilities, BiPredicate<OperationContext, Resource> filter) {
            this.capabilities = AbstractConfigurator.concat(this.capabilities, capabilities.stream(), filter);
            return this.self();
        }

        @Override
        public C requireChildResources(Set<? extends ResourceRegistration> children) {
            this.requiredChildren = this.requiredChildren.isEmpty() ? children.stream().collect(Collectors.toMap(ResourceRegistration::getPathElement, Function.identity())) : AbstractConfigurator.concat(this.requiredChildren, children.stream().map(child -> Map.entry(child.getPathElement(), child)));
            return this.self();
        }

        @Override
        public C requireSingletonChildResources(Set<? extends ResourceRegistration> children) {
            this.requiredSingletonChildren = this.requiredSingletonChildren.isEmpty() ? children.stream().collect(Collectors.toMap(ResourceRegistration::getPathElement, Function.identity())) : AbstractConfigurator.concat(this.requiredSingletonChildren, children.stream().map(child -> Map.entry(child.getPathElement(), child)));
            return this.self();
        }

        @Override
        public C addResourceCapabilityReferences(Collection<? extends ResourceCapabilityReference<?>> references) {
            this.resourceCapabilityReferences = references.isEmpty() ? Set.copyOf(references) : AbstractConfigurator.concat(this.resourceCapabilityReferences, references.stream());
            return this.self();
        }

        @Override
        public C withOperationTransformation(UnaryOperator<OperationStepHandler> transformation) {
            this.defaultOperationTransformer = transformation;
            return this.self();
        }

        @Override
        public C withOperationTransformation(Set<String> operationNames, UnaryOperator<OperationStepHandler> transformation) {
            this.operationTransformers = AbstractConfigurator.concat(this.operationTransformers, operationNames.stream(), transformation);
            return this.self();
        }

        @Override
        public C withResourceTransformation(UnaryOperator<Resource> transformation) {
            this.resourceTransformer = transformation;
            return this.self();
        }

        @Override
        public C withDeploymentChainContributor(Consumer<DeploymentProcessorTarget> contributor) {
            this.deploymentChainContributor = Optional.of(contributor);
            if (!RELOAD_RESTART_FLAGS.contains(this.addOperationRestartFlag)) {
                this.addOperationRestartFlag = OperationEntry.Flag.RESTART_ALL_SERVICES;
            }
            if (!RELOAD_RESTART_FLAGS.contains(this.removeOperationRestartFlag)) {
                this.removeOperationRestartFlag = OperationEntry.Flag.RESTART_ALL_SERVICES;
            }
            return this.self();
        }

        @Override
        public <P extends Supplier<AttributeDefinition>> C provideAttributes(Collection<P> providers) {
            this.attributes = AbstractConfigurator.concat(this.attributes, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<AttributeDefinition>> C provideModelOnlyAttributes(Collection<P> providers) {
            this.modelOnlyAttributes = AbstractConfigurator.concat(this.modelOnlyAttributes, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<AttributeDefinition>> C provideReadOnlyAttributes(Collection<P> providers) {
            this.readOnlyAttributes = AbstractConfigurator.concat(this.readOnlyAttributes, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<RuntimeCapability<?>>> C provideCapabilities(Collection<P> providers, BiPredicate<OperationContext, Resource> filter) {
            this.capabilities = AbstractConfigurator.concat(this.capabilities, ResourceDescriptor.stream(providers), filter);
            return this.self();
        }

        private static <T> Collection<T> copyOf(Collection<T> collection) {
            return collection instanceof Set ? Set.copyOf((Set)collection) : List.copyOf(collection);
        }

        private static <T> Collection<T> concat(Collection<T> collection, Stream<? extends T> additions) {
            return (collection.isEmpty() ? additions : Stream.concat(collection.stream(), additions)).collect(Collectors.toUnmodifiableList());
        }

        private static <T> Set<T> concat(Set<T> set, Stream<? extends T> additions) {
            return (set.isEmpty() ? additions : Stream.concat(set.stream(), additions)).collect(Collectors.toUnmodifiableSet());
        }

        private static <K, V> Map<K, V> concat(Map<K, V> map, K key, V value) {
            return map.isEmpty() ? Map.of(key, value) : AbstractConfigurator.concat(map, Stream.of(Map.entry(key, value)));
        }

        private static <K, V> Map<K, V> concat(Map<K, V> map, Stream<K> keys, V value) {
            return AbstractConfigurator.concat(map, keys.map(key -> Map.entry(key, value)));
        }

        private static <K, V> Map<K, V> concat(Map<K, V> map, Stream<Map.Entry<K, V>> entries) {
            return (map.isEmpty() ? entries : Stream.concat(map.entrySet().stream(), entries)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static interface Builder
    extends Configurator<Builder> {
        public ResourceDescriptor build();
    }

    public static interface Configurator<C extends Configurator<C>> {
        public C withRuntimeHandler(ResourceOperationRuntimeHandler var1);

        public C withAddOperationRestartFlag(OperationEntry.Flag var1);

        public C withRemoveOperationRestartFlag(OperationEntry.Flag var1);

        public C addAttributes(Collection<AttributeDefinition> var1);

        public C addAttribute(AttributeDefinition var1, OperationStepHandler var2);

        public C addModelOnlyAttributes(Collection<AttributeDefinition> var1);

        public C addReadOnlyAttributes(Collection<AttributeDefinition> var1);

        default public C renameAttribute(AttributeDefinition attribute, AttributeDefinition targetAttribute) {
            return this.translateAttribute(attribute, AttributeTranslation.alias(targetAttribute));
        }

        public C translateAttribute(AttributeDefinition var1, AttributeTranslation var2);

        default public C addCapability(RuntimeCapability<?> capability) {
            return this.addCapability(capability, AbstractConfigurator.DEFAULT_CAPABILITY_FILTER);
        }

        public C addCapability(RuntimeCapability<?> var1, BiPredicate<OperationContext, Resource> var2);

        default public C addCapabilities(Collection<RuntimeCapability<?>> capabilities) {
            return this.addCapabilities(capabilities, AbstractConfigurator.DEFAULT_CAPABILITY_FILTER);
        }

        public C addCapabilities(Collection<RuntimeCapability<?>> var1, BiPredicate<OperationContext, Resource> var2);

        @Deprecated(forRemoval=true, since="26.0.0")
        default public C requireChild(PathElement path) {
            return this.requireChildResources(Set.of(ResourceRegistration.of((PathElement)path)));
        }

        @Deprecated(forRemoval=true, since="26.0.0")
        default public C requireChildren(Set<PathElement> paths) {
            return this.requireChildResources(paths.stream().map(ResourceRegistration::of).collect(Collectors.toUnmodifiableSet()));
        }

        default public C requireChildResource(ResourceRegistration child) {
            return this.requireChildResources(Set.of(child));
        }

        public C requireChildResources(Set<? extends ResourceRegistration> var1);

        @Deprecated(forRemoval=true, since="26.0.0")
        default public C requireSingletonChild(PathElement path) {
            return this.requireSingletonChildResources(Set.of(ResourceRegistration.of((PathElement)path)));
        }

        @Deprecated(forRemoval=true, since="26.0.0")
        default public C requireSingletonChild(Set<PathElement> paths) {
            return this.requireSingletonChildResources(paths.stream().map(ResourceRegistration::of).collect(Collectors.toUnmodifiableSet()));
        }

        default public C requireSingletonChildResource(ResourceRegistration path) {
            return this.requireSingletonChildResources(Set.of(path));
        }

        public C requireSingletonChildResources(Set<? extends ResourceRegistration> var1);

        default public C addResourceCapabilityReference(ResourceCapabilityReference<?> reference) {
            return this.addResourceCapabilityReferences(Set.of(reference));
        }

        public C addResourceCapabilityReferences(Collection<? extends ResourceCapabilityReference<?>> var1);

        @Deprecated(forRemoval=true, since="26.0.0")
        default public C withAddResourceOperationTransformation(UnaryOperator<OperationStepHandler> transformation) {
            return this.withOperationTransformation("add", transformation);
        }

        public C withOperationTransformation(UnaryOperator<OperationStepHandler> var1);

        default public C withOperationTransformation(String operationName, UnaryOperator<OperationStepHandler> transformation) {
            return this.withOperationTransformation(Set.of(operationName), transformation);
        }

        public C withOperationTransformation(Set<String> var1, UnaryOperator<OperationStepHandler> var2);

        public C withResourceTransformation(UnaryOperator<Resource> var1);

        public C withDeploymentChainContributor(Consumer<DeploymentProcessorTarget> var1);

        public <P extends Supplier<AttributeDefinition>> C provideAttributes(Collection<P> var1);

        public <P extends Supplier<AttributeDefinition>> C provideModelOnlyAttributes(Collection<P> var1);

        public <P extends Supplier<AttributeDefinition>> C provideReadOnlyAttributes(Collection<P> var1);

        default public <P extends Supplier<RuntimeCapability<?>>> C provideCapabilities(Collection<P> providers) {
            return this.provideCapabilities(providers, AbstractConfigurator.DEFAULT_CAPABILITY_FILTER);
        }

        public <P extends Supplier<RuntimeCapability<?>>> C provideCapabilities(Collection<P> var1, BiPredicate<OperationContext, Resource> var2);

        @Deprecated(forRemoval=true, since="26.0.0")
        default public <P extends Supplier<PathElement>> C provideRequiredChildren(Collection<P> providers) {
            return this.requireChildResources(providers.stream().map(Supplier::get).map(ResourceRegistration::of).collect(Collectors.toUnmodifiableSet()));
        }

        @Deprecated(forRemoval=true, since="26.0.0")
        default public <P extends Supplier<PathElement>> C provideRequiredSingletonChildren(Collection<P> providers) {
            return this.requireSingletonChildResources(providers.stream().map(Supplier::get).map(ResourceRegistration::of).collect(Collectors.toUnmodifiableSet()));
        }
    }

    public static class DefaultResourceDescriptor
    implements ResourceDescriptor {
        static final BiPredicate<OperationContext, Resource> DISABLED_CAPABILITY = (context, resource) -> false;
        private final ResourceDescriptionResolver descriptionResolver;
        private final Optional<ResourceOperationRuntimeHandler> runtimeHandler;
        private final Map<RuntimeCapability<?>, BiPredicate<OperationContext, Resource>> capabilities;
        private final Map<AttributeDefinition, OperationStepHandler> readWriteAttributes = new HashMap<AttributeDefinition, OperationStepHandler>();
        private final Iterable<? extends AttributeDefinition> readOnlyAttributes;
        private final Map<PathElement, ResourceRegistration> requiredChildren;
        private final Map<PathElement, ResourceRegistration> requiredSingletonChildren;
        private final Map<AttributeDefinition, AttributeTranslation> attributeTranslations;
        private final Set<ResourceCapabilityReference<?>> resourceCapabilityReferences;
        private final Map<String, UnaryOperator<OperationStepHandler>> operationTransformers;
        private final UnaryOperator<OperationStepHandler> defaultOperationTransformer;
        private final UnaryOperator<Resource> resourceTransformer;
        private final Optional<Consumer<DeploymentProcessorTarget>> deploymentChainContributor;
        private final OperationEntry.Flag addOperationRestartFlag;
        private final OperationEntry.Flag removeOperationRestartFlag;

        DefaultResourceDescriptor(AbstractConfigurator<?> builder) {
            Collection<AttributeDefinition> modelOnlyAttributes;
            this.descriptionResolver = builder.descriptionResolver;
            this.runtimeHandler = builder.runtimeHandler;
            this.capabilities = builder.capabilities;
            Collection<AttributeDefinition> attributes = builder.attributes;
            if (!attributes.isEmpty()) {
                WriteAttributeOperationStepHandler handler = new WriteAttributeOperationStepHandler(this);
                for (AttributeDefinition attribute : attributes) {
                    this.readWriteAttributes.put(attribute, (OperationStepHandler)handler);
                }
            }
            if (!(modelOnlyAttributes = builder.modelOnlyAttributes).isEmpty()) {
                OperationStepHandlerDescriptor descriptor = new OperationStepHandlerDescriptor(){

                    @Override
                    public BiPredicate<OperationContext, Resource> getCapabilityFilter(RuntimeCapability<?> capability) {
                        return this.getCapabilityFilter(capability);
                    }
                };
                WriteAttributeOperationStepHandler handler = new WriteAttributeOperationStepHandler(descriptor);
                for (AttributeDefinition attribute : modelOnlyAttributes) {
                    this.readWriteAttributes.put(attribute, (OperationStepHandler)handler);
                }
            }
            this.readWriteAttributes.putAll(builder.customAttributes);
            this.readOnlyAttributes = builder.readOnlyAttributes;
            this.attributeTranslations = builder.attributeTranslations;
            this.requiredChildren = builder.requiredChildren;
            this.requiredSingletonChildren = builder.requiredSingletonChildren;
            this.resourceCapabilityReferences = builder.resourceCapabilityReferences;
            this.operationTransformers = builder.operationTransformers;
            this.defaultOperationTransformer = builder.defaultOperationTransformer;
            this.resourceTransformer = builder.resourceTransformer;
            this.deploymentChainContributor = builder.deploymentChainContributor;
            this.addOperationRestartFlag = builder.addOperationRestartFlag;
            this.removeOperationRestartFlag = builder.removeOperationRestartFlag;
        }

        @Override
        public ResourceDescriptionResolver getResourceDescriptionResolver() {
            return this.descriptionResolver;
        }

        @Override
        public Optional<ResourceOperationRuntimeHandler> getRuntimeHandler() {
            return this.runtimeHandler;
        }

        @Override
        public Set<RuntimeCapability<?>> getCapabilities() {
            return this.capabilities.keySet();
        }

        @Override
        public BiPredicate<OperationContext, Resource> getCapabilityFilter(RuntimeCapability<?> capability) {
            return this.capabilities.getOrDefault(capability, DISABLED_CAPABILITY);
        }

        @Override
        public Set<ResourceCapabilityReference<?>> getResourceCapabilityReferences() {
            return this.resourceCapabilityReferences;
        }

        @Override
        public UnaryOperator<OperationStepHandler> getOperationTransformation(String operationName) {
            return this.operationTransformers.getOrDefault(operationName, this.defaultOperationTransformer);
        }

        @Override
        public Iterable<AttributeDefinition> getAttributes() {
            return new CompositeIterable(new Iterable[]{this.attributeTranslations.keySet(), this.readWriteAttributes.keySet(), this.readOnlyAttributes});
        }

        @Override
        public AttributeTranslation getAttributeTranslation(AttributeDefinition attribute) {
            return this.attributeTranslations.get(attribute);
        }

        @Override
        public OperationStepHandler getWriteAttributeOperationStepHandler(AttributeDefinition attribute) {
            return this.readWriteAttributes.get(attribute);
        }

        @Override
        public Map<PathElement, ResourceRegistration> getRequiredChildResources() {
            return this.requiredChildren;
        }

        @Override
        public Map<PathElement, ResourceRegistration> getRequiredSingletonChildResources() {
            return this.requiredSingletonChildren;
        }

        @Override
        public UnaryOperator<Resource> getResourceTransformation() {
            return this.resourceTransformer;
        }

        @Override
        public Optional<Consumer<DeploymentProcessorTarget>> getDeploymentChainContributor() {
            return this.deploymentChainContributor;
        }

        @Override
        public OperationEntry.Flag getAddOperationRestartFlag() {
            return this.addOperationRestartFlag;
        }

        @Override
        public OperationEntry.Flag getRemoveOperationRestartFlag() {
            return this.removeOperationRestartFlag;
        }
    }
}

