/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.TernaryCapabilityNameResolver;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.ServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;

public interface ResourceCapabilityReferenceRecorder<T>
extends CapabilityReferenceRecorder<T> {
    public Function<PathAddress, String[]> getRequirementNameResolver();

    public void addCapabilityRequirements(OperationContext var1, Resource var2);

    public void removeCapabilityRequirements(OperationContext var1, Resource var2);

    default public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        this.addCapabilityRequirements(context, resource);
    }

    default public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        this.removeCapabilityRequirements(context, resource);
    }

    public static <T> Builder<T> builder(RuntimeCapability<Void> capability, NullaryServiceDescriptor<T> requirement) {
        return new Builder<T>(capability, requirement, ResourceCapabilityServiceDescriptorReference.EMPTY_RESOLVER);
    }

    public static <T> Builder<T> builder(RuntimeCapability<Void> capability, UnaryServiceDescriptor<T> requirement, UnaryCapabilityNameResolver requirementNameResolver) {
        return new Builder<T>(capability, requirement, (Function<PathAddress, String[]>)requirementNameResolver);
    }

    public static <T> Builder<T> builder(RuntimeCapability<Void> capability, BinaryServiceDescriptor<T> requirement, BinaryCapabilityNameResolver requirementNameResolver) {
        return new Builder<T>(capability, requirement, (Function<PathAddress, String[]>)requirementNameResolver);
    }

    public static <T> Builder<T> builder(RuntimeCapability<Void> capability, TernaryServiceDescriptor<T> requirement, TernaryCapabilityNameResolver requirementNameResolver) {
        return new Builder<T>(capability, requirement, (Function<PathAddress, String[]>)requirementNameResolver);
    }

    public static class ResourceCapabilityServiceDescriptorReference<T>
    extends AbstractResourceCapabilityServiceDescriptorReference<T> {
        private static final Function<PathAddress, String[]> EMPTY_RESOLVER = address -> new String[0];
        private static final BiPredicate<OperationContext, Resource> ALWAYS = (context, resource) -> true;
        private final BiPredicate<OperationContext, Resource> predicate;

        ResourceCapabilityServiceDescriptorReference(RuntimeCapability<Void> capability, ServiceDescriptor<T> requirement, Function<PathAddress, String[]> requirementNameResolver, BiPredicate<OperationContext, Resource> predicate) {
            super(capability, requirement, requirementNameResolver);
            this.predicate = predicate;
        }

        @Override
        public void addCapabilityRequirements(OperationContext context, Resource resource) {
            if (this.predicate.test(context, resource)) {
                context.registerAdditionalCapabilityRequirement(this.resolveRequirementName(context), this.resolveDependentName(context), null);
            }
        }

        @Override
        public void removeCapabilityRequirements(OperationContext context, Resource resource) {
            if (this.predicate.test(context, resource)) {
                context.deregisterCapabilityRequirement(this.resolveRequirementName(context), this.resolveDependentName(context));
            }
        }

        private String resolveRequirementName(OperationContext context) {
            String[] parts = this.getRequirementNameResolver().apply(context.getCurrentAddress());
            return parts.length > 0 ? RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseRequirementName(), (String[])parts) : this.getBaseRequirementName();
        }

        static BiPredicate<OperationContext, Resource> attributePredicate(final AttributeDefinition attribute, final Predicate<ModelNode> predicate) {
            return new BiPredicate<OperationContext, Resource>(){

                @Override
                public boolean test(OperationContext context, Resource resource) {
                    try {
                        return predicate.test(attribute.resolveModelAttribute(context, resource.getModel()));
                    }
                    catch (OperationFailedException e) {
                        return true;
                    }
                }
            };
        }
    }

    public static abstract class AbstractResourceCapabilityServiceDescriptorReference<T>
    extends CapabilityReferenceRecorder.AbstractCapabilityServiceDescriptorReferenceRecorder<T>
    implements ResourceCapabilityReferenceRecorder<T> {
        private final Function<PathAddress, String[]> requirementNameResolver;

        public AbstractResourceCapabilityServiceDescriptorReference(RuntimeCapability<Void> capability, ServiceDescriptor<T> requirement, Function<PathAddress, String[]> requirementNameResolver) {
            super(capability, requirement);
            this.requirementNameResolver = requirementNameResolver;
        }

        @Override
        public Function<PathAddress, String[]> getRequirementNameResolver() {
            return this.requirementNameResolver;
        }

        public String[] getRequirementPatternSegments(String name, PathAddress address) {
            String[] segments = this.requirementNameResolver.apply(address);
            for (int i = 0; i < segments.length; ++i) {
                String segment = segments[i];
                if (segment.charAt(0) != '$') continue;
                segments[i] = segment.substring(1);
            }
            return segments;
        }
    }

    public static class Builder<T> {
        private final RuntimeCapability<Void> capability;
        private final ServiceDescriptor<T> requirement;
        private final Function<PathAddress, String[]> requirementNameResolver;
        private BiPredicate<OperationContext, Resource> predicate = ResourceCapabilityServiceDescriptorReference.ALWAYS;

        Builder(RuntimeCapability<Void> capability, ServiceDescriptor<T> requirement, Function<PathAddress, String[]> requirementNameResolver) {
            this.capability = capability;
            this.requirement = requirement;
            this.requirementNameResolver = requirementNameResolver;
        }

        public Builder<T> when(final AttributeDefinition attribute, final Predicate<ModelNode> predicate) {
            this.predicate = new BiPredicate<OperationContext, Resource>(){

                @Override
                public boolean test(OperationContext context, Resource resource) {
                    try {
                        return predicate.test(attribute.resolveModelAttribute(context, resource.getModel()));
                    }
                    catch (OperationFailedException e) {
                        return true;
                    }
                }
            };
            return this;
        }

        public ResourceCapabilityReferenceRecorder<T> build() {
            return new ResourceCapabilityServiceDescriptorReference<T>(this.capability, this.requirement, this.requirementNameResolver, this.predicate);
        }
    }
}

