/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.Functions;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.service.Installer;
import org.wildfly.service.ServiceDependency;

public interface ServiceInstaller
extends Installer<ServiceTarget> {
    public static <V> UnaryBuilder<V, V> builder(V value) {
        return (UnaryBuilder)ServiceInstaller.builder(Functions.constantSupplier(value)).asActive();
    }

    public static <V> UnaryBuilder<V, V> builder(ServiceDependency<V> dependency) {
        ServiceDependency<V> supplier = dependency;
        return (UnaryBuilder)((UnaryBuilder)ServiceInstaller.builder(supplier).requires(dependency)).asPassive();
    }

    public static <V> UnaryBuilder<V, V> builder(Supplier<V> factory) {
        return ServiceInstaller.builder(Function.identity(), factory);
    }

    public static <T, V> UnaryBuilder<T, V> builder(Function<T, V> mapper, Supplier<T> factory) {
        return new DefaultUnaryBuilder<T, V>(mapper, factory);
    }

    public static Builder builder(final ServiceInstaller installer) {
        return (Builder)new DefaultNullaryBuilder(new Service(){

            public void start(StartContext context) {
                installer.install(context.getChildTarget());
            }

            public void stop(StopContext context) {
            }
        }).asActive();
    }

    public static Builder builder(final Runnable startTask, final Runnable stopTask) {
        return new DefaultNullaryBuilder(new Service(){

            public void start(StartContext context) {
                startTask.run();
            }

            public void stop(StopContext context) {
                stopTask.run();
            }
        });
    }

    public static interface UnaryBuilder<T, V>
    extends AsyncBuilder<UnaryBuilder<T, V>>,
    Installer.UnaryBuilder<UnaryBuilder<T, V>, ServiceInstaller, ServiceTarget, ServiceBuilder<?>, T, V> {
    }

    public static class DefaultUnaryBuilder<T, V>
    extends Installer.AbstractUnaryBuilder<UnaryBuilder<T, V>, ServiceInstaller, ServiceTarget, ServiceBuilder<?>, ServiceBuilder<?>, T, V>
    implements UnaryBuilder<T, V> {
        private volatile Supplier<Executor> executor = null;

        DefaultUnaryBuilder(Function<T, V> mapper, Supplier<T> factory) {
            super(mapper, factory);
        }

        @Override
        public UnaryBuilder<T, V> async(Supplier<Executor> executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public ServiceInstaller build() {
            final Supplier<Executor> executor = this.executor;
            final AsyncServiceBuilder.Async async = this.hasStopTask() ? AsyncServiceBuilder.Async.START_AND_STOP : AsyncServiceBuilder.Async.START_ONLY;
            return new DefaultServiceInstaller(this, new Function<ServiceTarget, ServiceBuilder<?>>(){

                @Override
                public ServiceBuilder<?> apply(ServiceTarget target) {
                    ServiceBuilder builder = target.addService();
                    return executor != null ? new AsyncServiceBuilder(builder, executor, async) : builder;
                }
            });
        }

        @Override
        protected UnaryBuilder<T, V> builder() {
            return this;
        }
    }

    public static class DefaultNullaryBuilder
    extends Installer.AbstractNullaryBuilder<Builder, ServiceInstaller, ServiceTarget, ServiceBuilder<?>, ServiceBuilder<?>>
    implements Builder {
        private volatile Supplier<Executor> executor = null;

        DefaultNullaryBuilder(Service service) {
            super(service);
        }

        @Override
        public Builder async(Supplier<Executor> executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public ServiceInstaller build() {
            final Supplier<Executor> executor = this.executor;
            return new DefaultServiceInstaller(this, new Function<ServiceTarget, ServiceBuilder<?>>(){

                @Override
                public ServiceBuilder<?> apply(ServiceTarget target) {
                    ServiceBuilder builder = target.addService();
                    return executor != null ? new AsyncServiceBuilder(builder, executor, AsyncServiceBuilder.Async.START_AND_STOP) : builder;
                }
            });
        }

        @Override
        protected Builder builder() {
            return this;
        }
    }

    public static interface Builder
    extends AsyncBuilder<Builder>,
    Installer.Builder<Builder, ServiceInstaller, ServiceTarget, ServiceBuilder<?>> {
    }

    public static class DefaultServiceInstaller
    extends Installer.DefaultInstaller<ServiceTarget, ServiceBuilder<?>, ServiceBuilder<?>>
    implements ServiceInstaller {
        DefaultServiceInstaller(Installer.Configuration<ServiceBuilder<?>, ServiceBuilder<?>> config, Function<ServiceTarget, ServiceBuilder<?>> serviceBuilderFactory) {
            super(config, serviceBuilderFactory);
        }
    }

    public static interface AsyncBuilder<B> {
        public B async(Supplier<Executor> var1);
    }
}

