/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import io.undertow.server.ListenerRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.management.BaseHttpInterfaceAddStepHandler;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ExternalManagementRequestExecutor;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementRequestsService;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.HttpShutdownService;
import org.jboss.as.server.mgmt.ManagementWorkerService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class HttpManagementAddHandler
extends BaseHttpInterfaceAddStepHandler {
    private static final String HTTP_AUTHENTICATION_FACTORY_CAPABILITY = "org.wildfly.security.http-authentication-factory";
    public static final HttpManagementAddHandler INSTANCE = new HttpManagementAddHandler();

    private HttpManagementAddHandler() {
        super(HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        HttpManagementResourceDefinition.addAttributeValidator(context);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && (context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY);
    }

    protected List<ServiceName> installServices(OperationContext context, HttpInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        String sslContext;
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        String socketBindingName = HttpManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asStringOrNull();
        String secureSocketBindingName = HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.resolveModelAttribute(context, model).asStringOrNull();
        if (socketBindingName != null) {
            if (secureSocketBindingName != null) {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocketAndSecureSocket(socketBindingName, secureSocketBindingName);
            } else {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocket(socketBindingName);
            }
        } else if (secureSocketBindingName != null) {
            ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSecureSocket(secureSocketBindingName);
        }
        ConsoleMode consoleMode = this.consoleMode(commonPolicy.isConsoleEnabled(), context.getRunningMode() == RunningMode.ADMIN_ONLY);
        ServiceName requestProcessorName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"});
        HttpManagementRequestsService.installService(requestProcessorName, (ServiceTarget)serviceTarget);
        NativeManagementServices.installManagementWorkerService((ServiceTarget)serviceTarget, context.getServiceRegistry(false));
        ServerEnvironment environment = (ServerEnvironment)context.getServiceRegistry(false).getRequiredService(ServerEnvironmentService.SERVICE_NAME).getValue();
        UndertowHttpManagementService undertowService = new UndertowHttpManagementService(consoleMode, environment.getProductConfig().getConsoleSlot());
        undertowService.getAllowedOriginsInjector().inject((Object)commonPolicy.getAllowedOrigins());
        CapabilityServiceBuilder undertowBuilder = serviceTarget.addCapability(UndertowHttpManagementService.EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY, (Service)undertowService).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, undertowService.getModelControllerInjector()).addCapabilityRequirement("org.wildfly.management.socket-binding-manager", SocketBindingManager.class, undertowService.getSocketBindingManagerInjector()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, undertowService.getControlledProcessStateServiceInjector()).addDependency(RemotingServices.HTTP_LISTENER_REGISTRY, ListenerRegistry.class, undertowService.getListenerRegistry()).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, undertowService.getRequestProcessorValue()).addDependency(ManagementWorkerService.SERVICE_NAME, XnioWorker.class, undertowService.getWorker()).addDependency(ExternalManagementRequestExecutor.SERVICE_NAME, Executor.class, undertowService.getManagementExecutor());
        if (socketBindingName != null) {
            undertowBuilder.addCapabilityRequirement("org.wildfly.network.socket-binding", SocketBinding.class, undertowService.getSocketBindingInjector(), new String[]{socketBindingName});
        }
        if (secureSocketBindingName != null) {
            undertowBuilder.addCapabilityRequirement("org.wildfly.network.socket-binding", SocketBinding.class, undertowService.getSecureSocketBindingInjector(), new String[]{secureSocketBindingName});
        }
        String httpAuthenticationFactory = commonPolicy.getHttpAuthenticationFactory();
        String securityRealm = commonPolicy.getSecurityRealm();
        if (httpAuthenticationFactory != null) {
            undertowBuilder.addCapabilityRequirement(HTTP_AUTHENTICATION_FACTORY_CAPABILITY, HttpAuthenticationFactory.class, undertowService.getHttpAuthenticationFactoryInjector(), new String[]{httpAuthenticationFactory});
        }
        if (securityRealm != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)undertowBuilder, undertowService.getSecurityRealmInjector(), (String)securityRealm);
        }
        if (httpAuthenticationFactory == null && securityRealm == null) {
            ServerLogger.ROOT_LOGGER.httpManagementInterfaceIsUnsecured();
        }
        if ((sslContext = commonPolicy.getSSLContext()) != null) {
            undertowBuilder.addCapabilityRequirement("org.wildfly.security.ssl-context", SSLContext.class, undertowService.getSSLContextInjector(), new String[]{sslContext});
        }
        undertowBuilder.install();
        HttpShutdownService shutdownService = new HttpShutdownService();
        ServiceName shutdownName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"});
        ServiceBuilder sb = serviceTarget.addService(shutdownName, (Service)shutdownService);
        sb.addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, shutdownService.getProcessorValue());
        sb.addDependency(Services.JBOSS_SERVER_EXECUTOR, Executor.class, shutdownService.getExecutorValue());
        sb.addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, shutdownService.getMgmtChannelRegistry());
        sb.requires(UndertowHttpManagementService.SERVICE_NAME);
        sb.install();
        if (commonPolicy.isHttpUpgradeEnabled()) {
            String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
            NativeManagementServices.installRemotingServicesIfNotInstalled((ServiceTarget)serviceTarget, hostName, context.getServiceRegistry(false));
            String httpConnectorName = socketBindingName != null || secureSocketBindingName == null ? "http-management" : "https-management";
            RemotingHttpUpgradeService.installServices((OperationContext)context, (String)"http-management", (String)httpConnectorName, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)commonPolicy.getConnectorOptions(), (String)securityRealm, (String)commonPolicy.getSaslAuthenticationFactory());
            return Arrays.asList(UndertowHttpManagementService.SERVICE_NAME, RemotingHttpUpgradeService.HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}));
        }
        return Collections.singletonList(UndertowHttpManagementService.SERVICE_NAME);
    }

    private ConsoleMode consoleMode(boolean consoleEnabled, boolean adminOnly) {
        return consoleEnabled ? (adminOnly ? ConsoleMode.ADMIN_ONLY : ConsoleMode.CONSOLE) : ConsoleMode.NO_CONSOLE;
    }
}

