/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.integration;

import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarFile;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class Seam2Processor
implements DeploymentUnitProcessor {
    public static final String SEAM_PROPERTIES = "seam.properties";
    public static final String SEAM_PROPERTIES_META_INF = "META-INF/seam.properties";
    public static final String SEAM_PROPERTIES_WEB_INF = "WEB-INF/classes/seam.properties";
    public static final String SEAM_COMPONENTS = "components.xml";
    public static final String SEAM_COMPONENTS_META_INF = "META-INF/components.xml";
    public static final String SEAM_COMPONENTS_WEB_INF = "WEB-INF/components.xml";
    public static final String[] SEAM_FILES = new String[]{"seam.properties", "META-INF/seam.properties", "WEB-INF/classes/seam.properties", "META-INF/components.xml", "WEB-INF/components.xml"};
    public static final String SEAM_INT_JAR = "jboss-seam-int-jbossas.jar";
    public static final ModuleIdentifier EXT_CONTENT_MODULE = ModuleIdentifier.create((String)"org.jboss.integration.ext-content");
    public static final ModuleIdentifier VFS_MODULE = ModuleIdentifier.create((String)"org.jboss.vfs");
    private ServiceTarget serviceTarget;
    private ResourceRoot seamIntResourceRoot;

    public Seam2Processor(ServiceTarget serviceTarget) {
        this.serviceTarget = serviceTarget;
    }

    protected synchronized ResourceRoot getSeamIntResourceRoot() throws DeploymentUnitProcessingException {
        try {
            if (this.seamIntResourceRoot == null) {
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                Module extModule = moduleLoader.loadModule(EXT_CONTENT_MODULE);
                URL url = extModule.getExportedResource(SEAM_INT_JAR);
                if (url == null) {
                    throw ServerLogger.ROOT_LOGGER.noSeamIntegrationJarPresent(extModule);
                }
                File file = new File(url.toURI());
                VirtualFile vf = VFS.getChild((URI)file.toURI());
                final Closeable mountHandle = VFS.mountZip((File)file, (VirtualFile)vf, (TempFileProvider)TempFileProviderService.provider());
                Service<Closeable> mountHandleService = new Service<Closeable>(){

                    public void start(StartContext startContext) throws StartException {
                    }

                    public void stop(StopContext stopContext) {
                        VFSUtils.safeClose((Closeable)mountHandle);
                    }

                    public Closeable getValue() throws IllegalStateException, IllegalArgumentException {
                        return mountHandle;
                    }
                };
                ServiceBuilder builder = this.serviceTarget.addService(ServiceName.JBOSS.append(new String[]{SEAM_INT_JAR}), (Service)mountHandleService);
                builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                this.serviceTarget = null;
                MountHandle dummy = new MountHandle(null);
                this.seamIntResourceRoot = new ResourceRoot(vf, dummy);
            }
            return this.seamIntResourceRoot;
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException(e);
        }
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ArrayList<DeploymentUnit> deploymentUnits = new ArrayList<DeploymentUnit>();
        deploymentUnits.add(deploymentUnit);
        deploymentUnits.addAll(deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS));
        for (DeploymentUnit unit : deploymentUnits) {
            ResourceRoot mainRoot = unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            if (mainRoot == null) continue;
            VirtualFile root = mainRoot.getRoot();
            for (String path : SEAM_FILES) {
                if (!root.getChild(path).exists()) continue;
                ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, VFS_MODULE, false, false, false, false));
                try {
                    IterableResourceLoader resourceLoader = ResourceLoaders.createJarResourceLoader((String)SEAM_INT_JAR, (JarFile)new JarFile(this.getSeamIntResourceRoot().getRoot().getPathName()));
                    moduleSpecification.addResourceLoader(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resourceLoader));
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException(e);
                }
                unit.addToAttachmentList(Attachments.RESOURCE_ROOTS, this.getSeamIntResourceRoot());
                return;
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

