/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitImpl;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.msc.service.ServiceRegistry;

public class SubDeploymentUnitService
extends AbstractDeploymentUnitService {
    private final ResourceRoot deploymentRoot;
    private final DeploymentUnit parent;
    private final PathManager pathManager;

    public SubDeploymentUnitService(ResourceRoot deploymentRoot, DeploymentUnit parent, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, CapabilityServiceSupport capabilityServiceSupport, AbstractVaultReader vaultReader, PathManager pathManager) {
        super(registration, mutableRegistration, resource, capabilityServiceSupport, vaultReader);
        this.pathManager = pathManager;
        if (deploymentRoot == null) {
            throw ServerLogger.ROOT_LOGGER.deploymentRootRequired();
        }
        this.deploymentRoot = deploymentRoot;
        if (parent == null) {
            throw ServerLogger.ROOT_LOGGER.subdeploymentsRequireParent();
        }
        this.parent = parent;
    }

    @Override
    protected DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry registry) {
        String deploymentName = this.deploymentRoot.getRootName();
        DeploymentUnitImpl deploymentUnit = new DeploymentUnitImpl(this.parent, deploymentName, registry);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, this.deploymentRoot);
        deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, new ModuleSpecification());
        deploymentUnit.putAttachment(DeploymentResourceSupport.REGISTRATION_ATTACHMENT, this.registration);
        deploymentUnit.putAttachment(DeploymentResourceSupport.MUTABLE_REGISTRATION_ATTACHMENT, this.mutableRegistration);
        deploymentUnit.putAttachment(DeploymentResourceSupport.DEPLOYMENT_RESOURCE, this.resource);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT, new DeploymentResourceSupport(deploymentUnit));
        deploymentUnit.putAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT, this.capabilityServiceSupport);
        deploymentUnit.putAttachment(Attachments.VAULT_READER_ATTACHMENT_KEY, this.vaultReader);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_OVERLAY_INDEX, this.parent.getAttachment(Attachments.DEPLOYMENT_OVERLAY_INDEX));
        deploymentUnit.putAttachment(Attachments.PATH_MANAGER, this.pathManager);
        deploymentUnit.putAttachment(Attachments.STABILITY_MONITOR, this.monitor);
        return deploymentUnit;
    }
}

