/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.DomainOperationTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class AffectedDeploymentOverlay {
    private AffectedDeploymentOverlay() {
    }

    public static Set<String> listAllLinks(OperationContext context, String overlay) {
        Set<String> serverGoupNames = AffectedDeploymentOverlay.listServerGroupsReferencingOverlay(context, overlay);
        HashSet<String> links = new HashSet<String>();
        for (String serverGoupName : serverGoupNames) {
            links.addAll(AffectedDeploymentOverlay.listLinks(context, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group", (String)serverGoupName), PathElement.pathElement((String)"deployment-overlay", (String)overlay)})));
        }
        return links;
    }

    public static Set<String> listLinks(OperationContext context, PathAddress overlayAddress) {
        Resource overlayResource = context.readResourceFromRoot(overlayAddress);
        if (overlayResource.hasChildren("deployment")) {
            return overlayResource.getChildrenNames("deployment");
        }
        return Collections.emptySet();
    }

    public static void redeployLinks(OperationContext context, PathAddress deploymentsRootAddress, Set<String> runtimeNames) throws OperationFailedException {
        Set<String> deploymentNames = AffectedDeploymentOverlay.listDeploymentNames(context, deploymentsRootAddress, runtimeNames.stream().map(wildcardExpr -> DeploymentOverlayIndex.getPattern(wildcardExpr)).collect(Collectors.toSet()));
        for (String deploymentName : deploymentNames) {
            PathAddress address = deploymentsRootAddress.append("deployment", deploymentName);
            OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(address, "redeploy");
            ModelNode operation = AffectedDeploymentOverlay.addRedeployStep(address);
            ServerLogger.AS_ROOT_LOGGER.debugf("Redeploying %s at address %s with handler %s", deploymentName, address, handler);
            assert (handler != null);
            assert (operation.isDefined());
            context.addStep(operation, handler, OperationContext.Stage.MODEL);
        }
    }

    public static void redeployLinksAndTransformOperationForDomain(OperationContext context, Set<String> runtimeNames, ModelNode removeOperation) throws OperationFailedException {
        ArrayList<OverlayOperationTransformer> transformers;
        Set<String> serverGroupNames = AffectedDeploymentOverlay.listServerGroupsReferencingOverlay(context, context.getCurrentAddressValue());
        HashMap<String, Set<String>> deploymentPerServerGroup = new HashMap<String, Set<String>>();
        for (String serverGoupName : serverGroupNames) {
            deploymentPerServerGroup.put(serverGoupName, AffectedDeploymentOverlay.listDeploymentNames(context, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group", (String)serverGoupName)}), runtimeNames.stream().map(wildcardExpr -> DeploymentOverlayIndex.getPattern(wildcardExpr)).collect(Collectors.toSet())));
        }
        if (deploymentPerServerGroup.isEmpty()) {
            runtimeNames.forEach(s -> ServerLogger.ROOT_LOGGER.debugf("We haven't found any server-group for %s", s));
            throw ServerLogger.ROOT_LOGGER.redeployingUnaffactedDeployments(runtimeNames);
        }
        Operations.CompositeOperationBuilder opBuilder = Operations.CompositeOperationBuilder.create();
        deploymentPerServerGroup.entrySet().stream().filter(entry -> !((Set)entry.getValue()).isEmpty()).forEach(entry -> ((Set)entry.getValue()).forEach(deploymentName -> opBuilder.addStep(AffectedDeploymentOverlay.addRedeployStep(context.getCurrentAddress().getParent().append("server-group", (String)entry.getKey()).append("deployment", deploymentName)))));
        if (removeOperation != null) {
            opBuilder.addStep(removeOperation);
        }
        if ((transformers = (ArrayList<OverlayOperationTransformer>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS)) == null) {
            transformers = new ArrayList<OverlayOperationTransformer>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS, transformers);
        }
        ModelNode slave = opBuilder.build().getOperation();
        transformers.add(new OverlayOperationTransformer(slave));
    }

    public static void redeployLinksAndTransformOperation(OperationContext context, ModelNode removeOperation, PathAddress deploymentsRootAddress, Set<String> runtimeNames) throws OperationFailedException {
        ArrayList<OverlayOperationTransformer> transformers;
        Set<String> deploymentNames = AffectedDeploymentOverlay.listDeploymentNames(context, deploymentsRootAddress, runtimeNames.stream().map(wildcardExpr -> DeploymentOverlayIndex.getPattern(wildcardExpr)).collect(Collectors.toSet()));
        if (deploymentNames.isEmpty()) {
            runtimeNames.forEach(s -> ServerLogger.ROOT_LOGGER.debugf("We haven't found any deployment for %s in server-group %s", s, deploymentsRootAddress.getLastElement().getValue()));
            throw ServerLogger.ROOT_LOGGER.redeployingUnaffactedDeployments(runtimeNames);
        }
        Operations.CompositeOperationBuilder opBuilder = Operations.CompositeOperationBuilder.create();
        for (String deploymentName : deploymentNames) {
            opBuilder.addStep(AffectedDeploymentOverlay.addRedeployStep(deploymentsRootAddress.append("deployment", deploymentName)));
        }
        if (removeOperation != null) {
            opBuilder.addStep(removeOperation);
        }
        if ((transformers = (ArrayList<OverlayOperationTransformer>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS)) == null) {
            transformers = new ArrayList<OverlayOperationTransformer>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS, transformers);
        }
        ModelNode slave = opBuilder.build().getOperation();
        transformers.add(new OverlayOperationTransformer(slave));
    }

    private static Set<String> listDeploymentNames(OperationContext context, PathAddress deploymentRootAddress, Set<Pattern> patterns) {
        HashSet<String> deploymentNames = new HashSet<String>();
        Resource deploymentRootResource = context.readResourceFromRoot(deploymentRootAddress);
        if (deploymentRootResource.hasChildren("deployment")) {
            for (Resource.ResourceEntry deploymentResource : deploymentRootResource.getChildren("deployment")) {
                if (AffectedDeploymentOverlay.isAcceptableDeployment(deploymentResource.getModel(), patterns)) {
                    deploymentNames.add(deploymentResource.getName());
                    continue;
                }
                if (!deploymentResource.hasChildren("subdeployment")) continue;
                for (Resource.ResourceEntry subdeploymentResource : deploymentResource.getChildren("subdeployment")) {
                    if (!AffectedDeploymentOverlay.isAcceptableDeployment(subdeploymentResource.getModel(), patterns)) continue;
                    deploymentNames.add(deploymentResource.getName());
                }
            }
        }
        return deploymentNames;
    }

    private static boolean isAcceptableDeployment(ModelNode deploymentNode, Set<Pattern> patterns) {
        return deploymentNode.get("enabled").asBoolean() && patterns.stream().anyMatch(pattern -> pattern.matcher(deploymentNode.require("runtime-name").asString()).matches());
    }

    private static ModelNode addRedeployStep(PathAddress address) {
        return Operations.createOperation((String)"redeploy", (ModelNode)address.toModelNode());
    }

    private static Set<String> listServerGroupsReferencingOverlay(OperationContext context, String overlayName) {
        Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        PathElement overlayPath = PathElement.pathElement((String)"deployment-overlay", (String)overlayName);
        if (rootResource.hasChildren("server-group")) {
            return rootResource.getChildrenNames("server-group").stream().filter(serverGroupName -> rootResource.getChild(PathElement.pathElement((String)"server-group", (String)serverGroupName)).hasChild(overlayPath)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Set<String> checkRequiredNames(Set<String> requiredNames, Set<String> runtimeNames) {
        return requiredNames.stream().map(wildcardExpr -> DeploymentOverlayIndex.getPattern(wildcardExpr)).filter(pattern -> !runtimeNames.stream().anyMatch(runtimeName -> pattern.matcher((CharSequence)runtimeName).matches())).map(Pattern::toString).collect(Collectors.toSet());
    }

    private static final class OverlayOperationTransformer
    implements DomainOperationTransformer {
        private final ModelNode newOperation;

        public OverlayOperationTransformer(ModelNode newOperation) {
            this.newOperation = newOperation;
        }

        public ModelNode transform(OperationContext context, ModelNode operation) {
            if (operation.get("operation").asString().equals("composite")) {
                ModelNode ret = operation.clone();
                ArrayList<ModelNode> list = new ArrayList<ModelNode>();
                ListIterator it = ret.get("steps").asList().listIterator();
                while (it.hasNext()) {
                    ModelNode subOperation = (ModelNode)it.next();
                    list.add(this.transform(context, subOperation));
                }
                ret.get("steps").set(list);
                return ret;
            }
            if (this.matches(operation)) {
                ServerLogger.AS_ROOT_LOGGER.debugf("Transforming operation %s into %s", operation, this.newOperation);
                return this.newOperation.clone();
            }
            return operation;
        }

        protected boolean matches(ModelNode operation) {
            return ("redeploy-links".equals(operation.get("operation").asString()) || "remove".equals(operation.get("operation").asString()) && operation.hasDefined("redeploy-affected") && operation.get("redeploy-affected").asBoolean()) && operation.get("address").asList().size() >= 1;
        }
    }
}

