/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.server.deploymentoverlay.AffectedDeploymentOverlay;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeploymentOverlayRedeployLinksHandler
implements OperationStepHandler {
    private static final StringListAttributeDefinition RUNTIME_NAMES_DEFINITION = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("deployments").setRequired(false)).build();
    public static final OperationDefinition REDEPLOY_LINKS_DEFINITION = new SimpleOperationDefinitionBuilder("redeploy-links", ControllerResolver.getResolver((String[])new String[]{"deployment-overlay"})).addParameter((AttributeDefinition)RUNTIME_NAMES_DEFINITION).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Set<String> runtimeNames = AffectedDeploymentOverlay.listLinks(context, context.getCurrentAddress());
        if (operation.hasDefined(RUNTIME_NAMES_DEFINITION.getName())) {
            HashSet<String> requiredRuntimeNames = new HashSet<String>(RUNTIME_NAMES_DEFINITION.unwrap((ExpressionResolver)context, operation));
            Set<String> unaffectedDeployments = AffectedDeploymentOverlay.checkRequiredNames(requiredRuntimeNames, runtimeNames);
            if (!unaffectedDeployments.isEmpty()) {
                throw ServerLogger.ROOT_LOGGER.redeployingUnaffactedDeployments(unaffectedDeployments);
            }
            runtimeNames = requiredRuntimeNames;
        }
        AffectedDeploymentOverlay.redeployLinks(context, context.getCurrentAddress().getParent(), runtimeNames);
    }
}

