/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;

public class ServerProcessStateHandler
implements OperationStepHandler {
    public static final String REQUIRE_RELOAD_OPERATION = "server-set-reload-required";
    public static final String REQUIRE_RESTART_OPERATION = "server-set-restart-required";
    public static final SimpleOperationDefinition RELOAD_DEFINITION = new SimpleOperationDefinitionBuilder("server-set-reload-required", ServerDescriptions.getResourceDescriptionResolver(new String[0])).withFlag(OperationEntry.Flag.HIDDEN).build();
    public static final SimpleOperationDefinition RESTART_DEFINITION = new SimpleOperationDefinitionBuilder("server-set-restart-required", ServerDescriptions.getResourceDescriptionResolver(new String[0])).withFlag(OperationEntry.Flag.HIDDEN).build();
    public static final OperationStepHandler SET_RELOAD_REQUIRED_HANDLER = new ServerProcessStateHandler(true);
    public static final OperationStepHandler SET_RESTART_REQUIRED_HANDLER = new ServerProcessStateHandler(false);
    private final boolean reload;

    ServerProcessStateHandler(boolean reload) {
        this.reload = reload;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.getServiceRegistry(true);
        if (this.reload) {
            context.reloadRequired();
        } else {
            context.restartRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (ServerProcessStateHandler.this.reload) {
                    context.revertReloadRequired();
                } else {
                    context.revertRestartRequired();
                }
            }
        });
    }
}

