/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.ServerSuspendController;
import org.jboss.dmr.ModelNode;

public class ServerResumeHandler
implements OperationStepHandler {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("resume", ServerDescriptions.getResourceDescriptionResolver("server")).setRuntimeOnly().build();
    private final ServerSuspendController suspendController;

    public ServerResumeHandler(ServerSuspendController suspendController) {
        this.suspendController = suspendController;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                AuthorizationResult authorizationResult = context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                    throw ControllerLogger.ACCESS_LOGGER.unauthorized(operation.get("operation").asString(), context.getCurrentAddress(), authorizationResult.getExplanation());
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            ServerLogger.ROOT_LOGGER.resumingServer();
                            ServerResumeHandler.this.suspendController.resume(ServerSuspendController.Context.RUNNING).toCompletableFuture().join();
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

