/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFSUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalModuleSpecService
implements Service<ModuleDefinition> {
    public static final int MAX_NUMBER_OF_JAR_RESOURCES = Integer.parseInt(WildFlySecurityManager.getPropertyPrivileged((String)"org.jboss.as.server.max_number_of_jar_resources", (String)"256"));
    private static final Logger log = Logger.getLogger(ExternalModuleSpecService.class);
    private final String moduleIdentifier;
    private final File file;
    private volatile ModuleDefinition moduleDefinition;
    private List<JarFile> jarFiles;

    @Deprecated(forRemoval=true, since="28.0.0")
    public ExternalModuleSpecService(ModuleIdentifier moduleIdentifier, File file) {
        this.moduleIdentifier = moduleIdentifier.toString();
        this.file = file;
        this.jarFiles = new ArrayList<JarFile>();
    }

    public ExternalModuleSpecService(String moduleIdentifier, File file) {
        this.moduleIdentifier = moduleIdentifier;
        this.file = file;
        this.jarFiles = new ArrayList<JarFile>();
    }

    public synchronized void start(StartContext context) throws StartException {
        ModuleSpec.Builder specBuilder;
        block12: {
            String currentName = "";
            try {
                if (!this.file.isDirectory()) {
                    currentName = this.file.toString();
                    this.jarFiles.add(new JarFile(this.file));
                    specBuilder = ModuleSpec.build((String)this.moduleIdentifier);
                    ExternalModuleSpecService.addResourceRoot(specBuilder, this.jarFiles.get(0));
                    log.debugf("Added %s jar file as resource root for %s module identifier", (Object)this.file.getAbsolutePath(), (Object)this.moduleIdentifier);
                    break block12;
                }
                specBuilder = ModuleSpec.build((String)this.moduleIdentifier);
                Path rootPath = this.file.toPath();
                ExternalModuleSpecService.addPathResourceRoot(specBuilder, rootPath);
                log.debugf("Added %s directory as resource root for %s module identifier", (Object)this.file.getAbsolutePath(), (Object)this.moduleIdentifier);
                ArrayList processedPaths = new ArrayList();
                try (Stream<Path> pathStream = Files.walk(rootPath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar"));){
                    pathStream.forEach(p -> {
                        processedPaths.add(p);
                        if (processedPaths.size() > MAX_NUMBER_OF_JAR_RESOURCES) {
                            throw new RuntimeException(ServerLogger.ROOT_LOGGER.maximumNumberOfJarResources(specBuilder.getName(), MAX_NUMBER_OF_JAR_RESOURCES));
                        }
                    });
                }
                if (!processedPaths.isEmpty()) {
                    TreeSet<Path> jars = new TreeSet<Path>(new PathComparator());
                    jars.addAll(processedPaths);
                    for (Path jar : jars) {
                        currentName = jar.toString();
                        JarFile jarFile = new JarFile(jar.toFile());
                        this.jarFiles.add(jarFile);
                        ExternalModuleSpecService.addResourceRoot(specBuilder, jarFile);
                        log.debugf("Added %s jar file as resource root for %s module identifier", (Object)jar.toString(), (Object)this.moduleIdentifier);
                    }
                }
            }
            catch (IOException e) {
                throw ServerLogger.ROOT_LOGGER.errorOpeningZipFile(currentName, e);
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
        }
        ExternalModuleSpecService.addEEDependencies(specBuilder);
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        ModuleSpec moduleSpec = specBuilder.create();
        this.moduleDefinition = new ModuleDefinition(this.moduleIdentifier, Collections.emptySet(), moduleSpec);
        ServiceModuleLoader.installModuleResolvedService(context.getChildTarget(), this.moduleIdentifier.toString());
    }

    public synchronized void stop(StopContext context) {
        for (JarFile jarFile : this.jarFiles) {
            log.debugf("Closing %s jar file which was added as resource root for %s module identifier", (Object)jarFile.getName(), (Object)this.moduleIdentifier);
            VFSUtils.safeClose((ZipFile)jarFile);
        }
        this.jarFiles.clear();
        this.jarFiles = null;
        this.moduleDefinition = null;
    }

    public ModuleDefinition getValue() throws IllegalStateException, IllegalArgumentException {
        return this.moduleDefinition;
    }

    private static void addResourceRoot(ModuleSpec.Builder specBuilder, JarFile file) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((JarFile)file)));
    }

    private static void addPathResourceRoot(ModuleSpec.Builder specBuilder, Path path) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createPathResourceLoader((Path)path)));
    }

    private static void addEEDependencies(ModuleSpec.Builder specBuilder) {
        ModuleDependencySpec dependencySpec = new ModuleDependencySpecBuilder().setName("wildflyee.api").setOptional(true).build();
        specBuilder.addDependency((DependencySpec)dependencySpec);
    }

    static class PathComparator
    implements Comparator<Path> {
        PathComparator() {
        }

        @Override
        public int compare(Path path1, Path path2) {
            int comparison;
            int path2Count;
            if (path1 == null && path2 != null) {
                return -1;
            }
            if (path1 != null && path2 == null) {
                return 1;
            }
            if (path1 == null && path2 == null) {
                return 0;
            }
            Path parentPath1 = path1.getParent();
            Path parentPath2 = path2.getParent();
            if (parentPath1 == null && parentPath2 != null) {
                return -1;
            }
            if (parentPath1 != null && parentPath2 == null) {
                return 1;
            }
            if (parentPath1 == null && parentPath2 == null) {
                return 0;
            }
            int path1Count = parentPath1.getNameCount();
            if (path1Count < (path2Count = parentPath2.getNameCount())) {
                if (path1Count == 0) {
                    return -1;
                }
                Path sameLevel = parentPath2.getRoot().resolve(parentPath2.subpath(0, path1Count));
                int comparison2 = this.compareBySameLevel(parentPath1, sameLevel);
                return comparison2 == 0 ? -1 : comparison2;
            }
            if (path2Count < path1Count) {
                if (path2Count == 0) {
                    return 1;
                }
                Path sameLevel = parentPath1.getRoot().resolve(parentPath1.subpath(0, path2Count));
                int comparison3 = this.compareBySameLevel(sameLevel, parentPath2);
                return comparison3 == 0 ? 1 : comparison3;
            }
            if (path2Count == path1Count && (comparison = this.compareBySameLevel(parentPath1, parentPath2)) != 0) {
                return comparison;
            }
            return path1.getFileName().compareTo(path2.getFileName());
        }

        private int compareBySameLevel(Path path1, Path path2) {
            Path levelPath2;
            Path levelPath1;
            int i = 0;
            int comparison = 0;
            Iterator<Path> iterPath1 = path1.iterator();
            while (iterPath1.hasNext() && (comparison = (levelPath1 = iterPath1.next()).compareTo(levelPath2 = path2.getName(i))) == 0) {
                ++i;
            }
            return comparison;
        }
    }
}

