/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class SubDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Object parentModule;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification parentModuleSpec = parent.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        String moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER).toString();
        if (deploymentUnit.getParent() != null && (parentModule = parent.getAttachment(Attachments.MODULE_IDENTIFIER)) != null) {
            ModuleDependency moduleDependency = ModuleDependency.Builder.of(moduleLoader, parentModule.toString()).setImportServices(true).build();
            moduleDependency.addImportFilter(PathFilters.acceptAll(), true);
            moduleSpec.addLocalDependency(moduleDependency);
        }
        for (AdditionalModuleSpecification module : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_MODULES)) {
            module.addLocalDependency(ModuleDependency.Builder.of(moduleLoader, moduleIdentifier.toString()).setImportServices(true).build());
        }
        List<DeploymentUnit> subDeployments = parent.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        ArrayList<ModuleDependency> accessibleModules = new ArrayList<ModuleDependency>();
        for (DeploymentUnit subDeployment : subDeployments) {
            ModuleSpecification subModule = subDeployment.getAttachment(Attachments.MODULE_SPECIFICATION);
            if (subModule.isPrivateModule() || parentModuleSpec.isSubDeploymentModulesIsolated() && !subModule.isPublicModule()) continue;
            String identifier = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER).toString();
            ModuleDependency dependency = ModuleDependency.Builder.of(moduleLoader, identifier).setImportServices(true).build();
            dependency.addImportFilter(PathFilters.acceptAll(), true);
            accessibleModules.add(dependency);
        }
        for (ModuleDependency dependency : accessibleModules) {
            if (dependency.getDependencyModule().equals(moduleIdentifier)) continue;
            moduleSpec.addLocalDependency(dependency);
        }
    }
}

