/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.AnnotationIndexSupport;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.Index;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class CompositeIndexProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        Reference<AnnotationIndexSupport> indexSupportRef = deploymentUnit.getAttachment(Attachments.ANNOTATION_INDEX_SUPPORT);
        assert (indexSupportRef != null);
        Boolean computeCompositeIndex = deploymentUnit.getAttachment(Attachments.COMPUTE_COMPOSITE_ANNOTATION_INDEX);
        if (computeCompositeIndex != null && !computeCompositeIndex.booleanValue()) {
            return;
        }
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        HashMap<String, AdditionalModuleSpecification> additionalModuleSpecificationMap = new HashMap<String, AdditionalModuleSpecification>();
        for (AdditionalModuleSpecification i : top.getAttachmentList(Attachments.ADDITIONAL_MODULES)) {
            additionalModuleSpecificationMap.put(i.getModuleName(), i);
        }
        for (ModuleIdentifier mi : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES)) {
            deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_INDEX_MODULES, mi.toString());
        }
        List<String> additionalModuleIndexes = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_INDEX_MODULES);
        HashMap<String, CompositeIndex> additionalAnnotationIndexes = new HashMap<String, CompositeIndex>();
        ArrayList<Index> indexes = new ArrayList<Index>();
        Map<String, DeploymentUnit> subdeploymentDependencies = this.buildSubdeploymentDependencyMap(deploymentUnit);
        for (String moduleName : additionalModuleIndexes) {
            AdditionalModuleSpecification additional = (AdditionalModuleSpecification)additionalModuleSpecificationMap.get(moduleName);
            if (additional != null) {
                ArrayList<Index> moduleIndexes = new ArrayList<Index>();
                for (ResourceRoot resource : additional.getResourceRoots()) {
                    ResourceRootIndexer.indexResourceRoot(resource);
                    Index indexAttachment = resource.getAttachment(Attachments.ANNOTATION_INDEX);
                    if (indexAttachment == null) continue;
                    indexes.add(indexAttachment);
                    moduleIndexes.add(indexAttachment);
                }
                if (moduleIndexes.isEmpty()) continue;
                additionalAnnotationIndexes.put(moduleName, new CompositeIndex(moduleIndexes));
                continue;
            }
            if (subdeploymentDependencies.containsKey(moduleName)) {
                ResourceRoot deploymentRoot;
                List resourceRoots = subdeploymentDependencies.get(moduleName).getAttachment(Attachments.RESOURCE_ROOTS);
                ArrayList<ResourceRoot> arrayList = new ArrayList<ResourceRoot>();
                if (resourceRoots != null) {
                    arrayList.addAll(resourceRoots);
                }
                if (ModuleRootMarker.isModuleRoot(deploymentRoot = subdeploymentDependencies.get(moduleName).getAttachment(Attachments.DEPLOYMENT_ROOT))) {
                    arrayList.add(deploymentRoot);
                }
                ArrayList<Index> moduleIndexes = new ArrayList<Index>();
                for (ResourceRoot resourceRoot : arrayList) {
                    Index index = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
                    if (index == null) continue;
                    indexes.add(index);
                    moduleIndexes.add(index);
                }
                if (moduleIndexes.isEmpty()) continue;
                additionalAnnotationIndexes.put(moduleName, new CompositeIndex(moduleIndexes));
                continue;
            }
            AnnotationIndexSupport annotationIndexSupport = indexSupportRef.get();
            CompositeIndex externalModuleIndexes = annotationIndexSupport != null ? annotationIndexSupport.getAnnotationIndices(moduleName, moduleLoader) : AnnotationIndexSupport.indexModule(moduleName, moduleLoader);
            indexes.addAll(externalModuleIndexes.indexes);
            additionalAnnotationIndexes.put(moduleName, externalModuleIndexes);
        }
        deploymentUnit.putAttachment(Attachments.ADDITIONAL_ANNOTATION_INDEXES_BY_MODULE_NAME, Collections.unmodifiableMap(additionalAnnotationIndexes));
        ArrayList<? extends ResourceRoot> allResourceRoots = new ArrayList<ResourceRoot>();
        List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (SubDeploymentMarker.isSubDeployment(resourceRoot) || !ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
            allResourceRoots.add(resourceRoot);
        }
        allResourceRoots.addAll(this.handleClassPathItems(deploymentUnit));
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (ModuleRootMarker.isModuleRoot(deploymentRoot)) {
            allResourceRoots.add(deploymentRoot);
        }
        for (ResourceRoot resourceRoot : allResourceRoots) {
            Index index = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            indexes.add(index);
        }
        deploymentUnit.putAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX, new CompositeIndex(indexes));
    }

    private Map<String, DeploymentUnit> buildSubdeploymentDependencyMap(DeploymentUnit deploymentUnit) {
        HashSet<String> depModuleIdentifiers = new HashSet<String>();
        for (ModuleDependency dep : deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION).getAllDependencies()) {
            depModuleIdentifiers.add(dep.getDependencyModule());
        }
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        HashMap<String, DeploymentUnit> res = new HashMap<String, DeploymentUnit>();
        AttachmentList<DeploymentUnit> subDeployments = top.getAttachment(Attachments.SUB_DEPLOYMENTS);
        if (subDeployments != null) {
            for (DeploymentUnit subDeployment : subDeployments) {
                String moduleIdentifier = subDeployment.getAttachment(Attachments.MODULE_NAME);
                if (!depModuleIdentifiers.contains(moduleIdentifier)) continue;
                res.put(moduleIdentifier, subDeployment);
            }
        }
        return res;
    }

    private Collection<? extends ResourceRoot> handleClassPathItems(DeploymentUnit deploymentUnit) {
        HashSet<ResourceRoot> additionalRoots = new HashSet<ResourceRoot>();
        ArrayDeque<ResourceRoot> toProcess = new ArrayDeque<ResourceRoot>();
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        toProcess.addAll(resourceRoots);
        HashSet<ResourceRoot> processed = new HashSet<ResourceRoot>(resourceRoots);
        while (!toProcess.isEmpty()) {
            ResourceRoot root = (ResourceRoot)toProcess.pop();
            List<ResourceRoot> classPathRoots = root.getAttachmentList(Attachments.CLASS_PATH_RESOURCE_ROOTS);
            for (ResourceRoot cpRoot : classPathRoots) {
                if (processed.contains(cpRoot)) continue;
                additionalRoots.add(cpRoot);
                toProcess.add(cpRoot);
                processed.add(cpRoot);
            }
        }
        return additionalRoots;
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
    }
}

