/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.ServerSuspendController;
import org.jboss.dmr.ModelNode;

public class ServerSuspendHandler
implements OperationStepHandler {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("suspend", ServerDescriptions.getResourceDescriptionResolver("server")).setParameters(new AttributeDefinition[]{ServerRootResourceDefinition.TIMEOUT, ServerRootResourceDefinition.SUSPEND_TIMEOUT}).setRuntimeOnly().build();
    private final ServerSuspendController suspendController;

    public ServerSuspendHandler(ServerSuspendController suspendController) {
        this.suspendController = suspendController;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        ServerRootResourceDefinition.renameTimeoutToSuspendTimeout(operation);
        final int seconds = ServerRootResourceDefinition.SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerSuspendController suspendController = ServerSuspendHandler.this.suspendController;
                ServerLogger.ROOT_LOGGER.suspendingServer(seconds, TimeUnit.SECONDS);
                CompletableFuture<Void> suspend = suspendController.suspend(ServerSuspendController.Context.RUNNING).toCompletableFuture();
                if (seconds >= 0) {
                    suspend.completeOnTimeout(null, seconds, TimeUnit.SECONDS);
                }
                try {
                    suspend.join();
                }
                catch (CancellationException e) {
                    context.setRollbackOnly();
                }
                context.completeStep((OperationContext.ResultHandler)new RollbackHandler(suspendController));
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    private static final class RollbackHandler
    implements OperationContext.ResultHandler {
        private final ServerSuspendController controller;

        private RollbackHandler(ServerSuspendController controller) {
            this.controller = controller;
        }

        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                ServerLogger.ROOT_LOGGER.resumingServer();
                this.controller.resume(ServerSuspendController.Context.RUNNING).toCompletableFuture().join();
            }
        }
    }
}

