/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class ManagedExplodedContentServitor
implements Service {
    private final Consumer<VirtualFile> virtualFileConsumer;
    private final Supplier<ContentRepository> contentRepositorySupplier;
    private final Supplier<ServerEnvironment> serverEnvironmentSupplier;
    private final Supplier<ExecutorService> executorSupplier;
    private final String managementName;
    private final byte[] hash;
    private volatile Path deploymentRoot;

    static ServiceController<?> addService(OperationContext context, ServiceName serviceName, String managementName, byte[] hash) {
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addService(serviceName);
        Consumer vfConsumer = sb.provides(new ServiceName[]{serviceName});
        Supplier crSupplier = sb.requires(ContentRepository.SERVICE_NAME);
        Supplier seSupplier = sb.requires(ServerEnvironment.SERVICE_DESCRIPTOR);
        Supplier<ExecutorService> esSupplier = Services.requireServerExecutor(sb);
        sb.setInstance((Service)new ManagedExplodedContentServitor(managementName, hash, vfConsumer, crSupplier, seSupplier, esSupplier));
        return sb.install();
    }

    private ManagedExplodedContentServitor(String managementName, byte[] hash, Consumer<VirtualFile> virtualFileConsumer, Supplier<ContentRepository> contentRepositorySupplier, Supplier<ServerEnvironment> serverEnvironmentSupplier, Supplier<ExecutorService> executorSupplier) {
        this.managementName = managementName;
        this.hash = hash;
        this.virtualFileConsumer = virtualFileConsumer;
        this.contentRepositorySupplier = contentRepositorySupplier;
        this.serverEnvironmentSupplier = serverEnvironmentSupplier;
        this.executorSupplier = executorSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        final Path root = DeploymentHandlerUtil.getExplodedDeploymentRoot(this.serverEnvironmentSupplier.get(), this.managementName);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CountDownLatch latch = ManagedExplodedContentServitor.this.asyncCleanup(root);
                    if (latch != null) {
                        try {
                            if (!latch.await(60L, TimeUnit.SECONDS)) {
                                context.failed(new StartException());
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            context.failed(new StartException());
                            return;
                        }
                    }
                    Files.createDirectories(root.getParent(), new FileAttribute[0]);
                    ManagedExplodedContentServitor.this.contentRepositorySupplier.get().copyExplodedContent(ManagedExplodedContentServitor.this.hash, root);
                    ManagedExplodedContentServitor.this.deploymentRoot = root;
                    ManagedExplodedContentServitor.this.virtualFileConsumer.accept(VFS.getChild((String)ManagedExplodedContentServitor.this.deploymentRoot.toAbsolutePath().toString()));
                    context.complete();
                }
                catch (IOException | ExplodedContentException e) {
                    context.failed(new StartException(e));
                }
            }
        };
        try {
            this.executorSupplier.get().execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        final Path theRoot = this.deploymentRoot;
        this.deploymentRoot = null;
        if (theRoot != null) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            ManagedExplodedContentServitor.this.virtualFileConsumer.accept(null);
                            CountDownLatch latch = ManagedExplodedContentServitor.this.asyncCleanup(theRoot);
                            if (latch == null) break block7;
                            try {
                                if (latch.await(60L, TimeUnit.SECONDS)) {
                                    // empty if block
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            context.complete();
                        }
                    }
                }
            };
            try {
                this.executorSupplier.get().execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        }
    }

    private CountDownLatch asyncCleanup(final Path root) throws IOException {
        CountDownLatch result;
        if (root.toFile().exists()) {
            result = new CountDownLatch(1);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ManagedExplodedContentServitor.recursiveDelete(root);
                    }
                    finally {
                        result.countDown();
                    }
                }
            };
            this.executorSupplier.get().submit(r);
        } else {
            result = null;
        }
        return result;
    }

    private static void recursiveDelete(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(path);){
                files.forEach(ManagedExplodedContentServitor::recursiveDelete);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

