/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLoggerImpl;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.persistence.ConfigurationExtension;
import org.jboss.as.controller.persistence.ConfigurationExtensionFactory;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.controller.git.GitRepository;
import org.jboss.as.server.controller.git.GitRepositoryConfiguration;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Stability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;

public class ServerEnvironment
extends ProcessEnvironment
implements Serializable {
    public static final NullaryServiceDescriptor<ServerEnvironment> SERVICE_DESCRIPTOR = NullaryServiceDescriptor.of((String)"org.wildfly.server.environment", ServerEnvironment.class);
    private static final long serialVersionUID = 1725061010357265545L;
    public static final String JAVA_EXT_DIRS = "java.ext.dirs";
    public static final String HOME_DIR = "jboss.home.dir";
    public static final String VFS_MODULE_IDENTIFIER = "org.jboss.vfs";
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_DATA_DIR = "jboss.server.data.dir";
    public static final String SERVER_CONTENT_DIR = "jboss.server.content.dir";
    public static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    public static final String SERVER_TEMP_DIR = "jboss.server.temp.dir";
    public static final String CONTROLLER_TEMP_DIR = "jboss.controller.temp.dir";
    public static final String NODE_NAME = "jboss.node.name";
    public static final String SERVER_NAME = "jboss.server.name";
    public static final String HOST_NAME = "jboss.host.name";
    public static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    public static final String BOOTSTRAP_MAX_THREADS = "org.jboss.server.bootstrap.maxThreads";
    public static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    public static final String JBOSS_BIND_ADDRESS_PREFIX = "jboss.bind.address.";
    public static final String JBOSS_DEFAULT_MULTICAST_ADDRESS = "jboss.default.multicast.address";
    public static final String JBOSS_SERVER_DEFAULT_CONFIG = "jboss.server.default.config";
    public static final String JBOSS_SERVER_MANAGEMENT_UUID = "jboss.server.management.uuid";
    @Deprecated
    public static final String JBOSS_PERSIST_SERVER_CONFIG = "jboss.server.persist.config";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final Set<String> ILLEGAL_PROPERTIES = new HashSet<String>(Arrays.asList("jboss.domain.base.dir", "jboss.domain.config.dir", "java.ext.dirs", "jboss.home.dir", "modules.path", "jboss.server.base.dir", "jboss.server.config.dir", "jboss.server.data.dir", "jboss.server.log.dir", "org.jboss.server.bootstrap.maxThreads", "jboss.controller.temp.dir", "jboss.server.default.config", "jboss.server.persist.config", "jboss.server.management.uuid", "jboss.stability"));
    private static final Set<String> BOOT_PROPERTIES = new HashSet<String>(Arrays.asList("jboss.server.temp.dir", "jboss.node.name", "jboss.server.name", "jboss.host.name", "jboss.qualified.host.name", "jboss.stability"));
    private final Properties primordialProperties;
    private final Properties providedProperties;
    private volatile boolean processNameSet;
    private final LaunchType launchType;
    private final String hostControllerName;
    private volatile String qualifiedHostName;
    private volatile String hostName;
    private volatile String serverName;
    private volatile String nodeName;
    private final File[] javaExtDirs;
    private final File homeDir;
    private final File serverBaseDir;
    private final File serverConfigurationDir;
    private final ConfigurationFile serverConfigurationFile;
    private final File serverLogDir;
    private final File controllerTempDir;
    private final File serverDataDir;
    private volatile File serverContentDir;
    private volatile File serverTempDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final boolean standalone;
    private final boolean allowModelControllerExecutor;
    private final RunningMode initialRunningMode;
    private final ProductConfig productConfig;
    private final RunningModeControl runningModeControl;
    private final UUID serverUUID;
    private final long startTime;
    private final boolean startSuspended;
    private final boolean startGracefully;
    private final GitRepository repository;
    private volatile Stability stability;
    private static final File[] NO_FILES = new File[0];

    public ServerEnvironment(String hostControllerName, Properties props, Map<String, String> env, String serverConfig, ConfigurationFile.InteractionPolicy configInteractionPolicy, LaunchType launchType, RunningMode initialRunningMode, ProductConfig productConfig, boolean startSuspended) {
        this(hostControllerName, props, env, serverConfig, configInteractionPolicy, launchType, initialRunningMode, productConfig, System.currentTimeMillis(), startSuspended, false, null, null, null, null);
    }

    public ServerEnvironment(String hostControllerName, Properties props, Map<String, String> env, String serverConfig, ConfigurationFile.InteractionPolicy configurationInteractionPolicy, LaunchType launchType, RunningMode initialRunningMode, ProductConfig productConfig, long startTime, boolean startSuspended, boolean startGracefully, String gitRepository, String gitBranch, String gitAuthConfiguration, String supplementalConfiguration) {
        UUID uuid;
        assert (props != null);
        assert (productConfig != null);
        ConfigurationFile.InteractionPolicy configInteractionPolicy = configurationInteractionPolicy;
        this.startSuspended = startSuspended;
        this.startGracefully = startGracefully;
        this.launchType = launchType;
        this.standalone = launchType != LaunchType.DOMAIN;
        this.productConfig = productConfig;
        this.initialRunningMode = initialRunningMode == null ? RunningMode.NORMAL : initialRunningMode;
        this.runningModeControl = new RunningModeControl(this.initialRunningMode);
        this.startTime = startTime;
        this.hostControllerName = hostControllerName;
        if (this.standalone && hostControllerName != null) {
            throw ServerLogger.ROOT_LOGGER.hostControllerNameNonNullInStandalone();
        }
        if (!this.standalone && hostControllerName == null) {
            throw ServerLogger.ROOT_LOGGER.hostControllerNameNullInDomain();
        }
        this.configureQualifiedHostName(props.getProperty(QUALIFIED_HOST_NAME), props.getProperty(HOST_NAME), props, env);
        this.javaExtDirs = this.getFilesFromProperty(JAVA_EXT_DIRS, props);
        if (launchType.equals((Object)LaunchType.SELF_CONTAINED)) {
            Path[] supplementalConfigurationFiles = this.findSupplementalConfigurationFiles(null, supplementalConfiguration);
            ConfigurationExtension configurationExtension = ConfigurationExtensionFactory.createConfigurationExtension((Path[])supplementalConfigurationFiles);
            if (configurationExtension != null) {
                configInteractionPolicy = configurationExtension.shouldProcessOperations(this.runningModeControl) ? ConfigurationFile.InteractionPolicy.READ_ONLY : configInteractionPolicy;
            }
            this.homeDir = new File(WildFlySecurityManager.getPropertyPrivileged((String)"user.dir", (String)"."));
            this.serverBaseDir = new File(WildFlySecurityManager.getPropertyPrivileged((String)"user.dir", (String)"."));
            this.serverLogDir = new File(WildFlySecurityManager.getPropertyPrivileged((String)"user.dir", (String)"."));
            String serverDirProp = props.getProperty(SERVER_TEMP_DIR);
            if (null == serverDirProp) {
                throw ServerLogger.ROOT_LOGGER.requiredSystemPropertyMissing(SERVER_TEMP_DIR);
            }
            this.serverDataDir = this.serverTempDir = new File(serverDirProp);
            this.serverConfigurationDir = null;
            this.serverConfigurationFile = null;
            this.controllerTempDir = this.serverTempDir;
            this.domainBaseDir = null;
            this.domainConfigurationDir = null;
            this.repository = null;
            this.stability = this.productConfig.getDefaultStability();
            WildFlySecurityManager.setPropertyPrivileged((String)JBOSS_PERSIST_SERVER_CONFIG, (String)"false");
        } else {
            this.homeDir = this.getFileFromProperty(HOME_DIR, props);
            if (this.homeDir == null) {
                throw ServerLogger.ROOT_LOGGER.missingHomeDirConfiguration(HOME_DIR);
            }
            if (!this.homeDir.exists() || !this.homeDir.isDirectory()) {
                throw ServerLogger.ROOT_LOGGER.homeDirectoryDoesNotExist(this.homeDir);
            }
            File tmp = this.getFileFromProperty(SERVER_BASE_DIR, props);
            if (tmp == null) {
                tmp = new File(this.homeDir, (String)(this.standalone ? "standalone" : "domain/servers/" + this.serverName));
            }
            if (this.standalone) {
                if (!tmp.exists()) {
                    throw ServerLogger.ROOT_LOGGER.serverBaseDirectoryDoesNotExist(tmp);
                }
                if (!tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.serverBaseDirectoryIsNotADirectory(tmp);
                }
            } else if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.serverBaseDirectoryIsNotADirectory(tmp);
                }
            } else if (!tmp.mkdirs()) {
                throw ServerLogger.ROOT_LOGGER.couldNotCreateServerBaseDirectory(tmp);
            }
            this.serverBaseDir = tmp;
            tmp = this.getFileFromProperty(SERVER_CONFIG_DIR, props);
            if (tmp == null) {
                tmp = new File(this.serverBaseDir, "configuration");
            }
            this.serverConfigurationDir = tmp;
            if (!(!this.standalone || this.serverConfigurationDir.exists() && this.serverConfigurationDir.isDirectory())) {
                throw ServerLogger.ROOT_LOGGER.configDirectoryDoesNotExist(this.serverConfigurationDir);
            }
            Path[] supplementalConfigurationFiles = this.findSupplementalConfigurationFiles(this.serverConfigurationDir.toPath(), supplementalConfiguration);
            ConfigurationExtension configurationExtension = ConfigurationExtensionFactory.createConfigurationExtension((Path[])supplementalConfigurationFiles);
            if (configurationExtension != null) {
                ConfigurationFile.InteractionPolicy interactionPolicy = configInteractionPolicy = configurationExtension.shouldProcessOperations(this.runningModeControl) ? ConfigurationFile.InteractionPolicy.READ_ONLY : configInteractionPolicy;
            }
            if ((tmp = this.getFileFromProperty(SERVER_DATA_DIR, props)) == null) {
                tmp = new File(this.serverBaseDir, "data");
            }
            this.serverDataDir = tmp;
            if (this.serverDataDir.exists()) {
                if (!this.serverDataDir.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.serverDataDirectoryIsNotDirectory(this.serverDataDir);
                }
            } else if (!this.serverDataDir.mkdirs()) {
                throw ServerLogger.ROOT_LOGGER.couldNotCreateServerDataDirectory(this.serverDataDir);
            }
            if ((tmp = this.getFileFromProperty(SERVER_CONTENT_DIR, props)) == null) {
                tmp = new File(this.serverDataDir, "content");
            }
            this.serverContentDir = tmp;
            if (this.serverContentDir.exists()) {
                if (!this.serverContentDir.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.serverContentDirectoryIsNotDirectory(this.serverContentDir);
                }
            } else if (!this.serverContentDir.mkdirs()) {
                throw ServerLogger.ROOT_LOGGER.couldNotCreateServerContentDirectory(this.serverContentDir);
            }
            if ((tmp = this.getFileFromProperty(SERVER_LOG_DIR, props)) == null) {
                tmp = new File(this.serverBaseDir, "log");
            }
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.logDirectoryIsNotADirectory(tmp);
                }
            } else if (!tmp.mkdirs()) {
                throw ServerLogger.ROOT_LOGGER.couldNotCreateLogDirectory(tmp);
            }
            this.serverLogDir = tmp;
            tmp = this.configureServerTempDir(props.getProperty(SERVER_TEMP_DIR), props);
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.serverTempDirectoryIsNotADirectory(tmp);
                }
            } else if (!tmp.mkdirs()) {
                throw ServerLogger.ROOT_LOGGER.couldNotCreateServerTempDirectory(tmp);
            }
            this.createAuthDir(tmp);
            tmp = this.getFileFromProperty(CONTROLLER_TEMP_DIR, props);
            if (tmp == null) {
                tmp = this.serverTempDir;
            }
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.controllerTempDirectoryIsNotADirectory(tmp);
                }
            } else if (!tmp.mkdirs()) {
                throw ServerLogger.ROOT_LOGGER.couldNotCreateControllerTempDirectory(tmp);
            }
            this.controllerTempDir = tmp;
            String defaultServerConfig = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_SERVER_DEFAULT_CONFIG, (String)"standalone.xml");
            GitRepositoryConfiguration gitConfiguration = GitRepositoryConfiguration.Builder.getInstance().setBasePath(this.serverBaseDir.toPath()).setAuthenticationConfig(gitAuthConfiguration).setBranch(gitBranch).setRepository(gitRepository).setIgnored(this.listIgnoredFiles(defaultServerConfig)).build();
            if (gitConfiguration != null) {
                try {
                    this.repository = new GitRepository(gitConfiguration);
                }
                catch (Exception ex) {
                    ServerLogger.ROOT_LOGGER.errorUsingGit(ex, ex.getMessage());
                    throw ServerLogger.ROOT_LOGGER.unableToInitialiseGitRepository(ex);
                }
            } else {
                this.repository = null;
            }
            this.stability = ServerEnvironment.getEnumProperty(props, "jboss.stability", productConfig.getDefaultStability());
            String translatedConfig = ServerEnvironment.translateFileAlias(serverConfig, this.stability);
            this.serverConfigurationFile = this.standalone ? new ConfigurationFile(this.serverConfigurationDir, defaultServerConfig, translatedConfig, configInteractionPolicy, this.repository != null, this.serverTempDir, configurationExtension) : null;
            String propertyKey = JBOSS_PERSIST_SERVER_CONFIG;
            WildFlySecurityManager.setPropertyPrivileged((String)JBOSS_PERSIST_SERVER_CONFIG, (String)Boolean.toString(configInteractionPolicy == null || !configInteractionPolicy.isReadOnly()));
            tmp = this.getFileFromProperty(DOMAIN_BASE_DIR, props);
            if (tmp != null) {
                if (!tmp.exists() || !tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.domainBaseDirDoesNotExist(tmp);
                }
                this.domainBaseDir = tmp;
            } else {
                this.domainBaseDir = null;
            }
            tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR, props);
            if (tmp != null) {
                if (!tmp.exists() || !tmp.isDirectory()) {
                    throw ServerLogger.ROOT_LOGGER.domainConfigDirDoesNotExist(tmp);
                }
                this.domainConfigurationDir = tmp;
            } else {
                this.domainConfigurationDir = null;
            }
            if (!productConfig.getStabilitySet().contains(this.stability)) {
                throw ServerLogger.ROOT_LOGGER.unsupportedStability(this.stability, productConfig.getProductName());
            }
        }
        boolean allowExecutor = true;
        String maxThreads = WildFlySecurityManager.getPropertyPrivileged((String)BOOTSTRAP_MAX_THREADS, null);
        if (maxThreads != null && !maxThreads.isEmpty()) {
            try {
                Integer.decode(maxThreads);
                allowExecutor = false;
            }
            catch (NumberFormatException ex) {
                ServerLogger.ROOT_LOGGER.failedToParseCommandLineInteger(BOOTSTRAP_MAX_THREADS, maxThreads);
            }
        }
        this.allowModelControllerExecutor = allowExecutor;
        Path filePath = this.serverDataDir.toPath().resolve("kernel").resolve("process-uuid");
        try {
            String sysPropUUID = props.getProperty(JBOSS_SERVER_MANAGEMENT_UUID);
            uuid = this.obtainProcessUUID(filePath, sysPropUUID);
        }
        catch (IOException ex) {
            throw ServerLogger.ROOT_LOGGER.couldNotObtainServerUuidFile(ex, filePath);
        }
        this.serverUUID = uuid;
        this.primordialProperties = new Properties();
        ServerEnvironment.copyProperties(props, this.primordialProperties);
        this.providedProperties = new Properties();
        ServerEnvironment.copyProperties(this.primordialProperties, this.providedProperties);
        WildFlySecurityManager.setPropertyPrivileged((String)QUALIFIED_HOST_NAME, (String)this.qualifiedHostName);
        WildFlySecurityManager.setPropertyPrivileged((String)HOST_NAME, (String)this.hostName);
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_NAME, (String)this.serverName);
        WildFlySecurityManager.setPropertyPrivileged((String)NODE_NAME, (String)this.nodeName);
        this.setPathProperty(HOME_DIR, this.homeDir);
        this.setPathProperty(SERVER_BASE_DIR, this.serverBaseDir);
        this.setPathProperty(SERVER_CONFIG_DIR, this.serverConfigurationDir);
        this.setPathProperty(SERVER_DATA_DIR, this.serverDataDir);
        this.setPathProperty(SERVER_LOG_DIR, this.serverLogDir);
        this.setPathProperty(SERVER_TEMP_DIR, this.serverTempDir);
        if (launchType.getProcessType() == ProcessType.DOMAIN_SERVER) {
            if (this.domainBaseDir != null) {
                WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_BASE_DIR, (String)this.domainBaseDir.getAbsolutePath());
            }
            if (this.domainConfigurationDir != null) {
                WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_CONFIG_DIR, (String)this.domainConfigurationDir.getAbsolutePath());
            }
        }
        try {
            ModuleLoader bootLoader = Module.getBootModuleLoader();
            Module vfsModule = bootLoader.loadModule(VFS_MODULE_IDENTIFIER);
            Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
        }
        catch (Exception ex) {
            ServerLogger.ROOT_LOGGER.cannotAddURLStreamHandlerFactory(ex, VFS_MODULE_IDENTIFIER);
        }
    }

    private Set<String> listIgnoredFiles(String defaultServerConfig) {
        LinkedHashSet<String> ignored = new LinkedHashSet<String>();
        this.setIgnored(ignored, this.serverDataDir.toPath(), true, false);
        this.setUnignored(ignored, this.serverDataDir.toPath(), false);
        this.setUnignored(ignored, this.serverContentDir.toPath(), true);
        this.setIgnored(ignored, this.serverConfigurationDir.toPath().resolve("logging.properties"), false, true);
        this.setIgnored(ignored, this.serverBaseDir.toPath().resolve("deployments"), false, false);
        this.setIgnored(ignored, this.serverLogDir.toPath(), false, false);
        this.setIgnored(ignored, this.serverTempDir.toPath(), false, false);
        this.setIgnored(ignored, this.serverConfigurationDir.toPath().resolve(defaultServerConfig.replace('.', '_') + "_history"), false, false);
        return ignored;
    }

    private void setIgnored(Set<String> ignored, Path path, boolean wilcard, boolean isFile) {
        Path serverBasePath = this.serverBaseDir.toPath();
        if (path.startsWith(serverBasePath)) {
            String ignoredBasePath = serverBasePath.relativize(path).toString().replace('\\', '/');
            if (wilcard) {
                ignored.add(ignoredBasePath + "/*");
            } else if (isFile) {
                ignored.add(ignoredBasePath);
            } else {
                ignored.add(ignoredBasePath + "/");
            }
        }
    }

    private void setUnignored(Set<String> ignored, Path path, boolean dir) {
        Path serverBasePath = this.serverBaseDir.toPath();
        if (path.startsWith(serverBasePath)) {
            ignored.add("!" + serverBasePath.relativize(path).toString().replace('\\', '/'));
        }
    }

    private void setPathProperty(String propertyName, File path) {
        if (this.launchType == LaunchType.SELF_CONTAINED && path == null) {
            return;
        }
        WildFlySecurityManager.setPropertyPrivileged((String)propertyName, (String)path.getAbsolutePath());
    }

    private static void copyProperties(Properties src, Properties dest) {
        for (Map.Entry<Object, Object> entry : src.entrySet()) {
            Object val;
            Object key = entry.getKey();
            if (!(key instanceof String) || (val = entry.getValue()) != null && !(val instanceof String)) continue;
            dest.setProperty((String)key, (String)val);
        }
    }

    private Path[] findSupplementalConfigurationFiles(Path serverConfigurationDirPath, String yaml) {
        ArrayList<Path> yamlPaths = new ArrayList<Path>();
        StringJoiner joiner = new StringJoiner(", ");
        boolean error = false;
        if (yaml != null && !yaml.isEmpty()) {
            for (String yamlFile : yaml.split(File.pathSeparator)) {
                Path yamlPath = new File(yamlFile).toPath();
                if (!yamlPath.isAbsolute()) {
                    if (Files.exists(yamlPath, new LinkOption[0]) && Files.isRegularFile(yamlPath, new LinkOption[0])) {
                        yamlPaths.add(yamlPath);
                        continue;
                    }
                    if (serverConfigurationDirPath != null) {
                        yamlPath = serverConfigurationDirPath.resolve(yamlFile);
                        if (Files.exists(yamlPath, new LinkOption[0]) && Files.isRegularFile(yamlPath, new LinkOption[0])) {
                            yamlPaths.add(yamlPath);
                            continue;
                        }
                        error = true;
                        joiner.add("'" + yamlFile + "'");
                        continue;
                    }
                    error = true;
                    joiner.add("'" + yamlFile + "'");
                    continue;
                }
                if (Files.exists(yamlPath, new LinkOption[0]) && Files.isRegularFile(yamlPath, new LinkOption[0])) {
                    yamlPaths.add(yamlPath);
                    continue;
                }
                error = true;
                joiner.add("'" + yamlFile + "'");
            }
        }
        if (error) {
            throw ServerLogger.ROOT_LOGGER.unableToFindYaml(joiner.toString());
        }
        return yamlPaths.toArray(new Path[0]);
    }

    void resetProvidedProperties() {
        this.providedProperties.clear();
        ServerEnvironment.copyProperties(this.primordialProperties, this.providedProperties);
        this.processNameSet = false;
    }

    public String getHostControllerName() {
        return this.hostControllerName;
    }

    public String getServerName() {
        return this.serverName;
    }

    private void configureServerName(String serverName, Properties providedProperties) {
        if (serverName == null || serverName.isBlank()) {
            serverName = this.hostName;
        } else {
            providedProperties.setProperty(SERVER_NAME, serverName);
            serverName = ServerEnvironment.resolveGUID((String)serverName);
        }
        this.serverName = serverName;
        this.configureNodeName(providedProperties.getProperty(NODE_NAME), providedProperties);
    }

    public String getQualifiedHostName() {
        return this.qualifiedHostName;
    }

    private void configureQualifiedHostName(String qualifiedHostName, String providedHostName, Properties providedProperties, Map<String, String> env) {
        if (qualifiedHostName == null) {
            qualifiedHostName = providedHostName;
            if (qualifiedHostName == null || qualifiedHostName.isBlank()) {
                qualifiedHostName = env.get("HOSTNAME");
            }
            if (qualifiedHostName == null || qualifiedHostName.isBlank()) {
                qualifiedHostName = env.get("COMPUTERNAME");
            }
            if (qualifiedHostName == null || qualifiedHostName.isBlank()) {
                try {
                    qualifiedHostName = NetworkUtils.canonize((String)InetAddressUtil.getLocalHost().getHostName());
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            qualifiedHostName = qualifiedHostName == null || qualifiedHostName.isBlank() ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase(Locale.getDefault());
        } else {
            providedProperties.setProperty(QUALIFIED_HOST_NAME, qualifiedHostName);
        }
        this.qualifiedHostName = qualifiedHostName;
        this.configureHostName(providedProperties.getProperty(HOST_NAME), providedProperties);
    }

    public String getHostName() {
        return this.hostName;
    }

    private void configureHostName(String hostName, Properties providedProperties) {
        if (hostName == null || hostName.isBlank()) {
            providedProperties.remove(HOST_NAME);
            int idx = this.qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? this.qualifiedHostName : this.qualifiedHostName.substring(0, idx);
        } else {
            providedProperties.setProperty(HOST_NAME, hostName);
        }
        this.hostName = hostName;
        this.configureServerName(providedProperties.getProperty(SERVER_NAME), providedProperties);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    private void configureNodeName(String nodeName, Properties providedProperties) {
        if (nodeName == null) {
            providedProperties.remove(NODE_NAME);
            nodeName = this.hostControllerName == null ? this.serverName : this.hostControllerName + ":" + this.serverName;
        } else {
            providedProperties.setProperty(NODE_NAME, nodeName);
        }
        this.nodeName = nodeName;
    }

    public File[] getJavaExtDirs() {
        return (File[])this.javaExtDirs.clone();
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getServerBaseDir() {
        return this.serverBaseDir;
    }

    public File getServerConfigurationDir() {
        return this.serverConfigurationDir;
    }

    public ConfigurationFile getServerConfigurationFile() {
        return this.serverConfigurationFile;
    }

    public File getServerDataDir() {
        return this.serverDataDir;
    }

    public File getServerContentDir() {
        return this.serverContentDir;
    }

    public File getServerLogDir() {
        return this.serverLogDir;
    }

    public File getServerTempDir() {
        return this.serverTempDir;
    }

    public boolean isStartSuspended() {
        return this.startSuspended;
    }

    public boolean isStartGracefully() {
        return this.startGracefully;
    }

    private File configureServerTempDir(String path, Properties providedProps) {
        File tmp = this.getFileFromPath(path);
        if (tmp == null) {
            providedProps.remove(SERVER_TEMP_DIR);
            tmp = new File(this.serverBaseDir, "tmp");
        } else {
            providedProps.setProperty(SERVER_TEMP_DIR, path);
        }
        this.serverTempDir = tmp;
        return tmp;
    }

    private void createAuthDir(File tempDir) {
        File authDir = new File(tempDir, "auth");
        if (authDir.exists()) {
            if (!authDir.isDirectory()) {
                throw ServerLogger.ROOT_LOGGER.unableToCreateTempDirForAuthTokensFileExists();
            }
        } else if (!authDir.mkdirs()) {
            if (!authDir.isDirectory()) {
                throw ServerLogger.ROOT_LOGGER.unableToCreateAuthDir(authDir.getAbsolutePath());
            }
        } else {
            authDir.setWritable(false, false);
            authDir.setWritable(true, true);
            authDir.setReadable(false, false);
            authDir.setReadable(true, true);
            authDir.setExecutable(false, false);
            authDir.setExecutable(true, true);
        }
    }

    File getControllerTempDir() {
        return this.controllerTempDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public LaunchType getLaunchType() {
        return this.launchType;
    }

    public Stability getStability() {
        return this.stability;
    }

    public Set<Stability> getStabilities() {
        return this.productConfig.getStabilitySet();
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public boolean isSelfContained() {
        return this.launchType == LaunchType.SELF_CONTAINED;
    }

    public RunningMode getInitialRunningMode() {
        return this.initialRunningMode;
    }

    public RunningModeControl getRunningModeControl() {
        return this.runningModeControl;
    }

    boolean isAllowModelControllerExecutor() {
        return this.allowModelControllerExecutor;
    }

    public ProductConfig getProductConfig() {
        return this.productConfig;
    }

    public UUID getInstanceUuid() {
        return this.serverUUID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean useGit() {
        return this.repository != null;
    }

    public GitRepository getGitRepository() {
        return this.repository;
    }

    public ConfigurationExtension getConfigurationExtension() {
        return this.getServerConfigurationFile() != null ? this.getServerConfigurationFile().getConfigurationExtension() : null;
    }

    public static int getBootstrapMaxThreads() {
        int cpuCount = ProcessorInfo.availableProcessors();
        int defaultThreads = cpuCount * 2;
        String maxThreads = WildFlySecurityManager.getPropertyPrivileged((String)BOOTSTRAP_MAX_THREADS, null);
        if (maxThreads != null && !maxThreads.isEmpty()) {
            try {
                int max = Integer.decode(maxThreads);
                defaultThreads = Math.max(max, 1);
            }
            catch (NumberFormatException ex) {
                ServerLogger.ROOT_LOGGER.failedToParseCommandLineInteger(BOOTSTRAP_MAX_THREADS, maxThreads);
            }
        }
        return defaultThreads;
    }

    protected String getProcessName() {
        return this.serverName;
    }

    protected void setProcessName(String processName) {
        if (processName != null) {
            if (this.primordialProperties.contains(SERVER_NAME)) {
                String rawServerProp = WildFlySecurityManager.getPropertyPrivileged((String)SERVER_NAME, (String)this.serverName);
                ServerLogger.AS_ROOT_LOGGER.duplicateServerNameConfiguration(SERVER_NAME, rawServerProp, processName);
            }
            this.serverName = processName;
            WildFlySecurityManager.setPropertyPrivileged((String)SERVER_NAME, (String)this.serverName);
            this.processNameSet = true;
            if (!this.primordialProperties.contains(NODE_NAME)) {
                this.nodeName = this.serverName;
                WildFlySecurityManager.setPropertyPrivileged((String)NODE_NAME, (String)this.nodeName);
            }
        }
    }

    protected boolean isRuntimeSystemPropertyUpdateAllowed(String propertyName, String propertyValue, boolean bootTime) throws OperationFailedException {
        if (ILLEGAL_PROPERTIES.contains(propertyName)) {
            throw ServerLogger.ROOT_LOGGER.systemPropertyNotManageable(propertyName);
        }
        if (this.processNameSet && SERVER_NAME.equals(propertyName)) {
            throw ServerLogger.ROOT_LOGGER.systemPropertyCannotOverrideServerName(SERVER_NAME);
        }
        return bootTime || !BOOT_PROPERTIES.contains(propertyName);
    }

    protected void systemPropertyUpdated(String propertyName, String propertyValue) {
        if (BOOT_PROPERTIES.contains(propertyName)) {
            if (SERVER_TEMP_DIR.equals(propertyName)) {
                this.configureServerTempDir(propertyValue, this.providedProperties);
            } else if (QUALIFIED_HOST_NAME.equals(propertyName)) {
                this.configureQualifiedHostName(propertyValue, this.providedProperties.getProperty(HOST_NAME), this.providedProperties, WildFlySecurityManager.getSystemEnvironmentPrivileged());
            } else if (HOST_NAME.equals(propertyName)) {
                this.configureHostName(propertyValue, this.providedProperties);
            } else if (SERVER_NAME.equals(propertyName)) {
                this.configureServerName(propertyValue, this.providedProperties);
            } else if (NODE_NAME.equals(propertyName)) {
                this.configureNodeName(propertyValue, this.providedProperties);
            }
        }
    }

    public void checkStabilityIsValidForInstallation(Stability stability) {
        this.checkStabilityIsValidForInstallation(this.productConfig, stability);
    }

    private void checkStabilityIsValidForInstallation(ProductConfig productConfig, Stability stability) {
        if (!productConfig.getStabilitySet().contains(stability)) {
            throw ServerLogger.ROOT_LOGGER.unsupportedStability(this.stability, productConfig.getProductName());
        }
    }

    void setStability(Stability stability) {
        WildFlySecurityManager.setPropertyPrivileged((String)"jboss.stability", (String)stability.toString());
        this.stability = stability;
    }

    private File getFileFromProperty(String name, Properties props) {
        return this.getFileFromPath(props.getProperty(name));
    }

    private static <E extends Enum<E>> E getEnumProperty(Properties properties, String key, E defaultValue) {
        String value = properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        Class<E> enumClass = defaultValue.getDeclaringClass();
        try {
            return Enum.valueOf(enumClass, value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw ServerLogger.ROOT_LOGGER.failedToParseEnumProperty(key, value, EnumSet.allOf(enumClass));
        }
    }

    private File getFileFromPath(String path) {
        File relative;
        File result;
        File file = result = path != null ? new File(path) : null;
        if (result != null && this.homeDir != null && !result.exists() && !result.isAbsolute() && (relative = new File(this.homeDir, path)).exists()) {
            result = relative;
        }
        return result;
    }

    private File[] getFilesFromProperty(String name, Properties props) {
        String sep = WildFlySecurityManager.getPropertyPrivileged((String)"path.separator", null);
        String value = props.getProperty(name, null);
        if (value != null) {
            String[] paths = value.split(Pattern.quote(sep));
            int len = paths.length;
            File[] files = new File[len];
            for (int i = 0; i < len; ++i) {
                files[i] = new File(paths[i]);
            }
            return files;
        }
        return NO_FILES;
    }

    ManagedAuditLogger createAuditLogger() {
        return new ManagedAuditLoggerImpl(this.getProductConfig().resolveVersion(), true);
    }

    public static String translateFileAlias(String alias, Stability stability) {
        if (!stability.enables(Stability.COMMUNITY) || alias == null) {
            return alias;
        }
        switch (alias) {
            case "full": 
            case "ha": 
            case "full-ha": 
            case "load-balancer": 
            case "microprofile": 
            case "microprofile-ha": {
                break;
            }
            case "fha": {
                alias = "full-ha";
                break;
            }
            case "lb": {
                alias = "load-balancer";
                break;
            }
            case "mp": {
                alias = "microprofile";
                break;
            }
            case "mpha": {
                alias = "microprofile-ha";
                break;
            }
            default: {
                return alias;
            }
        }
        return "standalone-" + alias + ".xml";
    }

    public static enum LaunchType {
        DOMAIN(ProcessType.DOMAIN_SERVER),
        STANDALONE(ProcessType.STANDALONE_SERVER),
        EMBEDDED(ProcessType.EMBEDDED_SERVER),
        SELF_CONTAINED(ProcessType.SELF_CONTAINED),
        APPCLIENT(ProcessType.APPLICATION_CLIENT);

        private final ProcessType processType;

        private LaunchType(ProcessType processType) {
            this.processType = processType;
        }

        public ProcessType getProcessType() {
            return this.processType;
        }
    }
}

