/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.protocol.mgmt.support.ManagementChannelShutdownHandle;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRequestTracker;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class HttpShutdownService
implements Service {
    private static final long SHUTDOWN_TIMEOUT = 15L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private final Supplier<Executor> executorSupplier;
    private final Supplier<ManagementHttpRequestProcessor> processorSupplier;
    private final Supplier<ManagementChannelRegistryService> registrySupplier;
    private volatile ManagementRequestTracker trackerService;

    public HttpShutdownService(Supplier<Executor> executorSupplier, Supplier<ManagementHttpRequestProcessor> processorSupplier, Supplier<ManagementChannelRegistryService> registrySupplier) {
        this.executorSupplier = executorSupplier;
        this.processorSupplier = processorSupplier;
        this.registrySupplier = registrySupplier;
    }

    public synchronized void start(StartContext context) throws StartException {
        final ManagementHttpRequestProcessor processor = this.processorSupplier.get();
        this.trackerService = this.registrySupplier.get().getTrackerService();
        this.trackerService.registerTracker((ManagementChannelShutdownHandle)processor);
        processor.addShutdownListener(new ManagementHttpRequestProcessor.ShutdownListener(){

            public void handleCompleted() {
                HttpShutdownService.this.trackerService.unregisterTracker((ManagementChannelShutdownHandle)processor);
            }
        });
    }

    public synchronized void stop(final StopContext context) {
        this.trackerService.prepareShutdown();
        context.asynchronous();
        try {
            this.executorSupplier.get().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpShutdownService.this.trackerService.awaitShutdown(15L, TIME_UNIT);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        context.complete();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            context.complete();
        }
    }
}

