/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathInfoHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerEnvironmentResourceDescription
extends SimpleResourceDefinition {
    public static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"core-service", (String)"server-environment");
    static final AttributeDefinition BASE_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"base-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition CONFIG_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"config-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition CONFIG_FILE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"config-file", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition CONTENT_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"content-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition DATA_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"data-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition DEPLOY_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"deploy-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition EXT_DIRS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ext-dirs", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition HOME_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"home-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition HOST_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"host-name", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition INITIAL_RUNNING_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-running-mode", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(RunningMode.class, (Enum[])new RunningMode[0]))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition LAUNCH_TYPE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"launch-type", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition LOG_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition NODE_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"node-name", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition QUALIFIED_HOST_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"qualified-host-name", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"server-name", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    static final AttributeDefinition TEMP_DIR = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"temp-dir", (ModelType)ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition START_SUSPENDED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-suspended", (ModelType)ModelType.BOOLEAN).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    public static final AttributeDefinition GRACEFUL_STARTUP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-gracefully", (ModelType)ModelType.BOOLEAN).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    private static final AttributeDefinition[] SERVER_ENV_ATTRIBUTES = new AttributeDefinition[]{BASE_DIR, CONFIG_DIR, CONFIG_FILE, CONTENT_DIR, DATA_DIR, DEPLOY_DIR, EXT_DIRS, HOME_DIR, HOST_NAME, INITIAL_RUNNING_MODE, LAUNCH_TYPE, LOG_DIR, NODE_NAME, QUALIFIED_HOST_NAME, SERVER_NAME, TEMP_DIR, START_SUSPENDED, GRACEFUL_STARTUP};
    private final ServerEnvironmentReadHandler osh;

    private ServerEnvironmentResourceDescription(ServerEnvironment environment) {
        super(new SimpleResourceDefinition.Parameters(RESOURCE_PATH, ServerDescriptions.getResourceDescriptionResolver("server.env")).setRuntime());
        this.osh = new ServerEnvironmentReadHandler(environment);
    }

    public static ServerEnvironmentResourceDescription of(ServerEnvironment environment) {
        return new ServerEnvironmentResourceDescription(environment);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : SERVER_ENV_ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this.osh);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        PathInfoHandler.registerOperation((ManagementResourceRegistration)resourceRegistration, (PathInfoHandler)PathInfoHandler.Builder.of(null).addAttribute(CONTENT_DIR, null).addAttribute(DATA_DIR, null).addAttribute(TEMP_DIR, null).addAttribute(LOG_DIR, null).build());
    }

    private static class ServerEnvironmentReadHandler
    implements OperationStepHandler {
        private final ServerEnvironment environment;

        ServerEnvironmentReadHandler(ServerEnvironment environment) {
            this.environment = environment;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            String name = operation.require("name").asString();
            if (this.equals(name, BASE_DIR)) {
                this.set(result, this.environment.getServerBaseDir());
            }
            if (this.equals(name, CONFIG_DIR)) {
                this.set(result, this.environment.getServerConfigurationDir());
            }
            if (this.equals(name, CONFIG_FILE)) {
                this.set(result, this.environment.getServerConfigurationFile());
            }
            if (this.equals(name, DATA_DIR)) {
                this.set(result, this.environment.getServerDataDir());
            }
            if (this.equals(name, CONTENT_DIR)) {
                this.set(result, this.environment.getServerContentDir());
            }
            if (this.equals(name, DEPLOY_DIR)) {
                this.set(result, this.environment.getServerContentDir());
            }
            if (this.equals(name, EXT_DIRS)) {
                this.set(result, this.environment.getJavaExtDirs());
            }
            if (this.equals(name, HOME_DIR)) {
                this.set(result, this.environment.getHomeDir());
            }
            if (this.equals(name, HOST_NAME)) {
                this.set(result, this.environment.getHostName());
            }
            if (this.equals(name, LAUNCH_TYPE)) {
                this.set(result, this.environment.getLaunchType().name());
            }
            if (this.equals(name, INITIAL_RUNNING_MODE)) {
                this.set(result, this.environment.getInitialRunningMode().name());
            }
            if (this.equals(name, LOG_DIR)) {
                this.set(result, this.environment.getServerLogDir());
            }
            if (this.equals(name, NODE_NAME)) {
                this.set(result, this.environment.getNodeName());
            }
            if (this.equals(name, QUALIFIED_HOST_NAME)) {
                this.set(result, this.environment.getQualifiedHostName());
            }
            if (this.equals(name, SERVER_NAME)) {
                this.set(result, this.environment.getServerName());
            }
            if (this.equals(name, TEMP_DIR)) {
                this.set(result, this.environment.getServerTempDir());
            }
            if (this.equals(name, START_SUSPENDED)) {
                result.set(this.environment.isStartSuspended());
            }
            if (this.equals(name, GRACEFUL_STARTUP)) {
                result.set(this.environment.isStartGracefully());
            }
        }

        private void set(ModelNode node, String value) {
            if (value != null) {
                node.set(value);
            }
        }

        private void set(ModelNode node, File value) {
            if (value != null) {
                node.set(value.getAbsolutePath());
            }
        }

        private void set(ModelNode node, File[] value) {
            if (value != null) {
                for (File file : value) {
                    node.add(file.getAbsolutePath());
                }
            }
        }

        private void set(ModelNode node, ConfigurationFile value) {
            if (value != null) {
                this.set(node, value.getBootFile());
            }
        }

        private boolean equals(String name, AttributeDefinition attribute) {
            return name.equals(attribute.getName());
        }
    }
}

