/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceName;

public class VirtualDomainMarkerUtility {
    private static final AttachmentKey<Boolean> REQUIRED = AttachmentKey.create(Boolean.class);
    private static final ServiceName DOMAIN_SUFFIX = ServiceName.of((String[])new String[]{"security-domain", "virtual"});
    private static final String VIRTUAL_SECURITY_DOMAIN_CAPABILITY = "org.wildfly.security.virtual-security-domain";

    public static void virtualDomainRequired(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualDomainMarkerUtility.toRoot(deploymentUnit);
        rootUnit.putAttachment(REQUIRED, Boolean.TRUE);
    }

    public static boolean isVirtualDomainRequired(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualDomainMarkerUtility.toRoot(deploymentUnit);
        Boolean required = rootUnit.getAttachment(REQUIRED);
        return required == null ? false : required;
    }

    public static ServiceName virtualDomainName(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualDomainMarkerUtility.toRoot(deploymentUnit);
        return rootUnit.getServiceName().append(DOMAIN_SUFFIX);
    }

    public static ServiceName virtualDomainName(String domainName) {
        return Services.deploymentUnitName(domainName).append(DOMAIN_SUFFIX);
    }

    public static ServiceName virtualDomainMetaDataName(DeploymentPhaseContext context, DeploymentUnit deploymentUnit) {
        CapabilityServiceSupport capabilityServiceSupport = context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        return capabilityServiceSupport.getCapabilityServiceName(VIRTUAL_SECURITY_DOMAIN_CAPABILITY, new String[]{VirtualDomainMarkerUtility.toRoot(deploymentUnit).getName()});
    }

    public static ServiceName virtualDomainMetaDataName(DeploymentPhaseContext context, String virtualDomainName) {
        CapabilityServiceSupport capabilityServiceSupport = context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        return capabilityServiceSupport.getCapabilityServiceName(VIRTUAL_SECURITY_DOMAIN_CAPABILITY, new String[]{virtualDomainName});
    }

    private static DeploymentUnit toRoot(DeploymentUnit deploymentUnit) {
        DeploymentUnit result = deploymentUnit;
        DeploymentUnit parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }
}

