/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ManifestHelper;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.server.deployment.reflect.ProxyMetadataSource;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.Module;

public final class InstallReflectionIndexProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Manifest manifest = deploymentUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (ManifestHelper.hasMainAttributeValue(manifest, "Fragment-Host")) {
            return;
        }
        Module module = deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw ServerLogger.ROOT_LOGGER.nullModuleAttachment(deploymentUnit);
        }
        if (deploymentUnit.getParent() == null) {
            DeploymentReflectionIndex index = DeploymentReflectionIndex.create();
            deploymentUnit.putAttachment(Attachments.REFLECTION_INDEX, index);
            deploymentUnit.putAttachment(Attachments.PROXY_REFLECTION_INDEX, new ProxyMetadataSource(index));
        } else {
            DeploymentReflectionIndex index = deploymentUnit.getParent().getAttachment(Attachments.REFLECTION_INDEX);
            deploymentUnit.putAttachment(Attachments.REFLECTION_INDEX, index);
            deploymentUnit.putAttachment(Attachments.PROXY_REFLECTION_INDEX, deploymentUnit.getParent().getAttachment(Attachments.PROXY_REFLECTION_INDEX));
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(Attachments.REFLECTION_INDEX);
    }
}

