/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitImpl;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VirtualFile;

final class RootDeploymentUnitService
extends AbstractDeploymentUnitService {
    private final InjectedValue<DeploymentMountProvider> serverDeploymentRepositoryInjector = new InjectedValue();
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final String name;
    private final String managementName;
    final InjectedValue<VirtualFile> contentsInjector = new InjectedValue();
    private final DeploymentUnit parent;
    private final ImmutableManagementResourceRegistration registration;
    private final ManagementResourceRegistration mutableRegistration;
    private final Resource resource;
    private final CapabilityServiceSupport capabilityServiceSupport;
    private final AbstractVaultReader vaultReader;
    private final DeploymentOverlayIndex deploymentOverlays;

    public RootDeploymentUnitService(String name, String managementName, DeploymentUnit parent, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, CapabilityServiceSupport capabilityServiceSupport, AbstractVaultReader vaultReader, DeploymentOverlayIndex deploymentOverlays) {
        assert (name != null) : "name is null";
        this.name = name;
        this.managementName = managementName;
        this.parent = parent;
        this.registration = registration;
        this.mutableRegistration = mutableRegistration;
        this.resource = resource;
        this.capabilityServiceSupport = capabilityServiceSupport;
        this.vaultReader = vaultReader;
        this.deploymentOverlays = deploymentOverlays;
    }

    @Override
    protected DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry registry) {
        DeploymentUnitImpl deploymentUnit = new DeploymentUnitImpl(this.parent, this.name, registry);
        deploymentUnit.putAttachment(Attachments.RUNTIME_NAME, this.name);
        deploymentUnit.putAttachment(Attachments.MANAGEMENT_NAME, this.managementName);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_CONTENTS, this.contentsInjector.getValue());
        deploymentUnit.putAttachment(DeploymentResourceSupport.REGISTRATION_ATTACHMENT, this.registration);
        deploymentUnit.putAttachment(DeploymentResourceSupport.MUTABLE_REGISTRATION_ATTACHMENT, this.mutableRegistration);
        deploymentUnit.putAttachment(DeploymentResourceSupport.DEPLOYMENT_RESOURCE, this.resource);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT, new DeploymentResourceSupport(deploymentUnit));
        deploymentUnit.putAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT, this.capabilityServiceSupport);
        deploymentUnit.putAttachment(Attachments.VAULT_READER_ATTACHMENT_KEY, this.vaultReader);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_OVERLAY_INDEX, this.deploymentOverlays);
        deploymentUnit.putAttachment(Attachments.PATH_MANAGER, this.pathManagerInjector.getValue());
        deploymentUnit.putAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY, this.serverDeploymentRepositoryInjector.getValue());
        RootDeploymentUnitService.addSVH(deploymentUnit);
        return deploymentUnit;
    }

    Injector<DeploymentMountProvider> getServerDeploymentRepositoryInjector() {
        return this.serverDeploymentRepositoryInjector;
    }

    InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    private static void addSVH(DeploymentUnit deploymentUnit) {
        deploymentUnit.putAttachment(Attachments.SERVICE_VERIFICATION_HANDLER, ServiceVerificationHandler.INSTANCE);
    }
}

