/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class LocalDestinationOutboundSocketBindingAddHandler
extends AbstractAddStepHandler {
    static final LocalDestinationOutboundSocketBindingAddHandler INSTANCE = new LocalDestinationOutboundSocketBindingAddHandler();

    private LocalDestinationOutboundSocketBindingAddHandler() {
        super(LocalDestinationOutboundSocketBindingResourceDefinition.OUTBOUND_SOCKET_BINDING_CAPABILITY, (AttributeDefinition[])LocalDestinationOutboundSocketBindingResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String outboundSocketName = address.getLastElement().getValue();
        try {
            LocalDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, model, outboundSocketName);
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(e.toString());
        }
    }

    public static void installOutboundSocketBindingService(OperationContext context, ModelNode model, String outboundSocketName) throws OperationFailedException, UnknownHostException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        String socketBindingRef = LocalDestinationOutboundSocketBindingResourceDefinition.SOCKET_BINDING_REF.resolveModelAttribute(context, model).asString();
        ModelNode sourceInterfaceModelNode = OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.resolveModelAttribute(context, model);
        String sourceInterfaceName = sourceInterfaceModelNode.isDefined() ? sourceInterfaceModelNode.asString() : null;
        ModelNode sourcePortModelNode = OutboundSocketBindingResourceDefinition.SOURCE_PORT.resolveModelAttribute(context, model);
        Integer sourcePort = sourcePortModelNode.isDefined() ? Integer.valueOf(sourcePortModelNode.asInt()) : null;
        boolean fixedSourcePort = OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.resolveModelAttribute(context, model).asBoolean();
        LocalDestinationOutboundSocketBindingService outboundSocketBindingService = new LocalDestinationOutboundSocketBindingService(outboundSocketName, sourcePort, fixedSourcePort);
        ServiceName serviceName = context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", outboundSocketName, OutboundSocketBinding.class);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)outboundSocketBindingService);
        if (sourceInterfaceName != null) {
            serviceBuilder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{sourceInterfaceName}), NetworkInterfaceBinding.class, outboundSocketBindingService.getSourceNetworkInterfaceBindingInjector());
        }
        serviceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.network.socket-binding", socketBindingRef, SocketBinding.class), SocketBinding.class, outboundSocketBindingService.getLocalDestinationSocketBindingInjector()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, outboundSocketBindingService.getSocketBindingManagerInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND).addAliases(new ServiceName[]{OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketName})}).install();
    }
}

