/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class BindingRuntimeHandlers {
    private BindingRuntimeHandlers() {
    }

    public static class BoundPortHandler
    extends AbstractBindingRuntimeHandler {
        public static final String ATTRIBUTE_NAME = "bound-port";
        public static final AttributeDefinition ATTRIBUTE_DEFINITION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"bound-port", (ModelType)ModelType.INT).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, false))).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
        public static final OperationStepHandler INSTANCE = new BoundPortHandler();

        private BoundPortHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                int port = managedBinding.getBindAddress().getPort();
                result.set(port);
            }
        }

        @Override
        ModelNode getNoMetrics() {
            return new ModelNode();
        }
    }

    public static class BoundAddressHandler
    extends AbstractBindingRuntimeHandler {
        public static final String ATTRIBUTE_NAME = "bound-address";
        public static final AttributeDefinition ATTRIBUTE_DEFINITION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"bound-address", (ModelType)ModelType.STRING).setRequired(false)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
        public static final OperationStepHandler INSTANCE = new BoundAddressHandler();

        private BoundAddressHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                InetAddress addr = managedBinding.getBindAddress().getAddress();
                result.set(NetworkUtils.canonize((String)addr.getHostAddress()));
            }
        }

        @Override
        ModelNode getNoMetrics() {
            return new ModelNode();
        }
    }

    public static class BoundHandler
    extends AbstractBindingRuntimeHandler {
        public static final String ATTRIBUTE_NAME = "bound";
        public static final AttributeDefinition ATTRIBUTE_DEFINITION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"bound", (ModelType)ModelType.BOOLEAN).setRequired(false)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
        public static final OperationStepHandler INSTANCE = new BoundHandler();

        private BoundHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            result.set(binding.isBound());
        }

        @Override
        ModelNode getNoMetrics() {
            return ModelNode.FALSE;
        }
    }

    static abstract class AbstractBindingRuntimeHandler
    implements OperationStepHandler {
        AbstractBindingRuntimeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode result = context.getResult();
                    String name = context.getCurrentAddressValue();
                    ServiceName svcName = SocketBindingResourceDefinition.SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(name, SocketBinding.class);
                    ServiceController controller = context.getServiceRegistry(false).getRequiredService(svcName);
                    if (controller != null && controller.getState() == ServiceController.State.UP) {
                        SocketBinding binding = (SocketBinding)SocketBinding.class.cast(controller.getValue());
                        this.execute(operation, binding, result);
                    } else {
                        result.set(this.getNoMetrics());
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }

        abstract void execute(ModelNode var1, SocketBinding var2, ModelNode var3);

        abstract ModelNode getNoMetrics();
    }
}

