/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public abstract class DeploymentHandlerUtils {
    private static final OperationContext.AttachmentKey<Boolean> CONTENT_REPOSITORY_FLUSH = OperationContext.AttachmentKey.create(Boolean.class);

    protected static String asString(ModelNode node, String name) {
        return node.has(name) ? node.require(name).asString() : null;
    }

    protected static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(msg);
    }

    protected static OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode(msg));
    }

    protected static DeploymentHandlerUtil.ContentItem[] getContents(ModelNode contentNode) {
        List nodes = contentNode.asList();
        DeploymentHandlerUtil.ContentItem[] contents = new DeploymentHandlerUtil.ContentItem[nodes.size()];
        for (int i = 0; i < contents.length; ++i) {
            ModelNode node = (ModelNode)nodes.get(i);
            contents[i] = node.has("hash") ? new DeploymentHandlerUtil.ContentItem(node.require("hash").asBytes(), DeploymentHandlerUtil.isArchive(node)) : new DeploymentHandlerUtil.ContentItem(node.require("path").asString(), DeploymentHandlerUtils.asString(node, "relative-to"), node.require("archive").asBoolean());
        }
        return contents;
    }

    public static InputStream getInputStream(OperationContext context, ModelNode contentItem) throws OperationFailedException {
        InputStream in = null;
        if (!contentItem.isDefined()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ZipOutputStream zout = new ZipOutputStream(out);){
                zout.putNextEntry(new ZipEntry(context.getCurrentAddressValue() + "/"));
                zout.closeEntry();
                out.close();
            }
            catch (IOException ioex) {
                throw new OperationFailedException((Throwable)ioex);
            }
            return new ByteArrayInputStream(out.toByteArray());
        }
        if (contentItem.hasDefined(DeploymentAttributes.CONTENT_INPUT_STREAM_INDEX.getName())) {
            int maxIndex;
            int streamIndex = DeploymentAttributes.CONTENT_INPUT_STREAM_INDEX.resolveModelAttribute(context, contentItem).asInt();
            if (streamIndex > (maxIndex = context.getAttachmentStreamCount())) {
                throw ServerLogger.ROOT_LOGGER.invalidStreamIndex(DeploymentAttributes.CONTENT_INPUT_STREAM_INDEX.getName(), streamIndex, maxIndex);
            }
            in = context.getAttachmentStream(streamIndex);
        } else {
            if (contentItem.hasDefined(DeploymentAttributes.CONTENT_BYTES.getName())) {
                try {
                    in = new ByteArrayInputStream(DeploymentAttributes.CONTENT_BYTES.resolveModelAttribute(context, contentItem).asBytes());
                }
                catch (IllegalArgumentException iae) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamBytes(DeploymentAttributes.CONTENT_BYTES.getName());
                }
            }
            if (contentItem.hasDefined(DeploymentAttributes.CONTENT_URL.getName())) {
                String urlSpec = DeploymentAttributes.CONTENT_URL.resolveModelAttribute(context, contentItem).asString();
                try {
                    in = new URL(urlSpec).openStream();
                }
                catch (MalformedURLException e) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamURL(e, urlSpec);
                }
                catch (IOException e) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamURL(e, urlSpec);
                }
            }
        }
        if (in == null) {
            throw new IllegalStateException();
        }
        return in;
    }

    public static boolean hasValidContentAdditionParameterDefined(ModelNode operation) {
        for (String s : DeploymentAttributes.MANAGED_CONTENT_ATTRIBUTES.keySet()) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    protected static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw ServerLogger.ROOT_LOGGER.multipleContentItemsNotSupported();
        }
    }

    public static InputStream emptyStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
    }

    public static void addFlushHandler(OperationContext context, final ContentRepository contentRepository, final OperationContext.ResultHandler handler) {
        if (context.getAttachment(CONTENT_REPOSITORY_FLUSH) == null) {
            context.attach(CONTENT_REPOSITORY_FLUSH, (Object)true);
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    handler.handleResult(resultAction, context, operation);
                    contentRepository.flush(resultAction == OperationContext.ResultAction.KEEP);
                    context.detach(CONTENT_REPOSITORY_FLUSH);
                }
            });
        } else {
            context.completeStep(handler);
        }
    }
}

