/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;

public final class DeploymentResourceSupport {
    static final AttachmentKey<Resource> DEPLOYMENT_RESOURCE = AttachmentKey.create(Resource.class);
    static final AttachmentKey<ImmutableManagementResourceRegistration> REGISTRATION_ATTACHMENT = AttachmentKey.create(ImmutableManagementResourceRegistration.class);
    static final AttachmentKey<ManagementResourceRegistration> MUTABLE_REGISTRATION_ATTACHMENT = AttachmentKey.create(ManagementResourceRegistration.class);
    private final DeploymentUnit deploymentUnit;

    protected DeploymentResourceSupport(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public boolean hasDeploymentSubsystemModel(String subsystemName) {
        Resource root = this.deploymentUnit.getAttachment(DEPLOYMENT_RESOURCE);
        PathElement subsystem = PathElement.pathElement((String)"subsystem", (String)subsystemName);
        return root.hasChild(subsystem);
    }

    public ModelNode getDeploymentSubsystemModel(String subsystemName) {
        assert (subsystemName != null) : "The subsystemName cannot be null";
        return DeploymentResourceSupport.getDeploymentSubModel(subsystemName, PathAddress.EMPTY_ADDRESS, null, this.deploymentUnit);
    }

    public ModelNode registerDeploymentSubsystemResource(String subsystemName, Resource resource) {
        assert (subsystemName != null) : "The subsystemName cannot be null";
        assert (resource != null) : "The resource cannot be null";
        return this.registerDeploymentSubResource(subsystemName, PathAddress.EMPTY_ADDRESS, resource);
    }

    public boolean hasDeploymentSubModel(String subsystemName, PathElement address) {
        PathElement subsystem;
        Resource root = this.deploymentUnit.getAttachment(DEPLOYMENT_RESOURCE);
        return root.hasChild(subsystem = PathElement.pathElement((String)"subsystem", (String)subsystemName)) && (address == null || root.getChild(subsystem).hasChild(address));
    }

    public boolean hasDeploymentSubModel(String subsystemName, PathAddress address) {
        Resource root = this.deploymentUnit.getAttachment(DEPLOYMENT_RESOURCE);
        PathElement subsystem = PathElement.pathElement((String)"subsystem", (String)subsystemName);
        boolean found = false;
        if (root.hasChild(subsystem)) {
            if (address == PathAddress.EMPTY_ADDRESS) {
                return true;
            }
            Resource parent = root.getChild(subsystem);
            for (PathElement child : address) {
                if (parent.hasChild(child)) {
                    found = true;
                    parent = parent.getChild(child);
                    continue;
                }
                found = false;
                break;
            }
        }
        return found;
    }

    public ModelNode getDeploymentSubModel(String subsystemName, PathElement address) {
        assert (subsystemName != null) : "The subsystemName cannot be null";
        return DeploymentResourceSupport.getDeploymentSubModel(subsystemName, address, this.deploymentUnit);
    }

    public ModelNode getDeploymentSubModel(String subsystemName, PathAddress address) {
        assert (subsystemName != null) : "The subsystemName cannot be null";
        assert (address != null) : "The address cannot be null";
        return DeploymentResourceSupport.getDeploymentSubModel(subsystemName, address, null, this.deploymentUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelNode registerDeploymentSubResource(String subsystemName, PathAddress address, Resource resource) {
        Resource root;
        Resource resource2 = root = this.deploymentUnit.getAttachment(DEPLOYMENT_RESOURCE);
        synchronized (resource2) {
            ImmutableManagementResourceRegistration registration = this.deploymentUnit.getAttachment(REGISTRATION_ATTACHMENT);
            PathElement subsystemPath = PathElement.pathElement((String)"subsystem", (String)subsystemName);
            if (address == PathAddress.EMPTY_ADDRESS) {
                return DeploymentResourceSupport.register(root, subsystemPath, resource).getModel();
            }
            Resource parent = DeploymentResourceSupport.getOrCreate(root, subsystemPath);
            int count = address.size() - 1;
            for (int index = 0; index < count; ++index) {
                parent = DeploymentResourceSupport.getOrCreate(parent, address.getElement(index));
            }
            ImmutableManagementResourceRegistration subModel = registration.getSubModel(DeploymentResourceSupport.getSubsystemAddress(subsystemName, address));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            return DeploymentResourceSupport.register(parent, address.getLastElement(), resource).getModel();
        }
    }

    static Resource getOrCreateSubDeployment(String deploymentName, DeploymentUnit parent) {
        Resource root = parent.getAttachment(DEPLOYMENT_RESOURCE);
        return DeploymentResourceSupport.getOrCreate(root, PathElement.pathElement((String)"subdeployment", (String)deploymentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup(Resource resource) {
        Resource resource2 = resource;
        synchronized (resource2) {
            for (Resource.ResourceEntry entry : resource.getChildren("subsystem")) {
                resource.removeChild(entry.getPathElement());
            }
            for (Resource.ResourceEntry entry : resource.getChildren("subdeployment")) {
                resource.removeChild(entry.getPathElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelNode getDeploymentSubModel(String subsystemName, PathElement address, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = unit.getAttachment(DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ImmutableManagementResourceRegistration registration = unit.getAttachment(REGISTRATION_ATTACHMENT);
            PathElement subsystemPath = PathElement.pathElement((String)"subsystem", (String)subsystemName);
            if (address == null) {
                return DeploymentResourceSupport.getOrCreate(root, subsystemPath, null).getModel();
            }
            Resource parent = DeploymentResourceSupport.getOrCreate(root, subsystemPath);
            ImmutableManagementResourceRegistration subModel = registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPath, address}));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            return DeploymentResourceSupport.getOrCreate(parent, address, null).getModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelNode getDeploymentSubModel(String subsystemName, PathAddress address, Resource resource, DeploymentUnit unit) {
        Resource root;
        Resource resource2 = root = unit.getAttachment(DEPLOYMENT_RESOURCE);
        synchronized (resource2) {
            ImmutableManagementResourceRegistration registration = unit.getAttachment(REGISTRATION_ATTACHMENT);
            PathElement subsystemPath = PathElement.pathElement((String)"subsystem", (String)subsystemName);
            if (address == PathAddress.EMPTY_ADDRESS) {
                return DeploymentResourceSupport.getOrCreate(root, subsystemPath, resource).getModel();
            }
            Resource parent = DeploymentResourceSupport.getOrCreate(root, subsystemPath);
            int count = address.size() - 1;
            for (int index = 0; index < count; ++index) {
                parent = DeploymentResourceSupport.getOrCreate(parent, address.getElement(index));
            }
            ImmutableManagementResourceRegistration subModel = registration.getSubModel(DeploymentResourceSupport.getSubsystemAddress(subsystemName, address));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            return DeploymentResourceSupport.getOrCreate(parent, address.getLastElement(), resource).getModel();
        }
    }

    private static Resource getOrCreate(Resource parent, PathElement element) {
        return DeploymentResourceSupport.getOrCreate(parent, element, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getOrCreate(Resource parent, PathElement element, Resource desired) {
        Resource resource = parent;
        synchronized (resource) {
            if (parent.hasChild(element)) {
                if (desired == null) {
                    return parent.requireChild(element);
                }
                throw new IllegalStateException();
            }
            return DeploymentResourceSupport.register(parent, element, desired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource register(Resource parent, PathElement element, Resource desired) {
        Resource resource = parent;
        synchronized (resource) {
            Resource toRegister = desired;
            if (toRegister == null) {
                toRegister = Resource.Factory.create((boolean)true);
            } else if (!toRegister.isRuntime()) {
                throw ControllerLogger.ROOT_LOGGER.deploymentResourceMustBeRuntimeOnly();
            }
            parent.registerChild(element, toRegister);
            return toRegister;
        }
    }

    private static PathAddress getSubsystemAddress(String subsystemName, PathAddress elements) {
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystemName)});
        address = address.append(elements);
        return address;
    }
}

