/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.controller.resources.ModuleInfoHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.management.ModuleLoaderMXBean;
import org.jboss.modules.management.ResourceLoaderInfo;

public class ModuleLoadingResourceDefinition
extends SimpleResourceDefinition {
    private static final AttributeDefinition MODULE_NAME = new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).build();
    public static final ModuleLoadingResourceDefinition INSTANCE = new ModuleLoadingResourceDefinition();

    private ModuleLoadingResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"core-service", (String)"module-loading"), ServerDescriptions.getResourceDescriptionResolver("core", "module-loading")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.MODULE_LOADING}).setFeature(false).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        SimpleListAttributeDefinition ad = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"module-roots", (AttributeDefinition)new SimpleAttributeDefinitionBuilder("module-root", ModelType.STRING).build()).setStorageRuntime()).setRuntimeServiceNotRequired()).setDeprecated(ModelVersion.create((int)1, (int)4, (int)0))).build();
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ad, (OperationStepHandler)new ListModuleRootsHandler());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        SimpleOperationDefinition definition = new SimpleOperationDefinitionBuilder("list-resource-loader-paths", this.getResourceDescriptionResolver()).addParameter(MODULE_NAME).setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).setDeprecated(ModelVersion.create((int)1, (int)4, (int)0)).setReadOnly().build();
        resourceRegistration.registerOperationHandler((OperationDefinition)definition, (OperationStepHandler)new ModuleLocationHandler());
        resourceRegistration.registerOperationHandler(ModuleInfoHandler.DEFINITION, (OperationStepHandler)ModuleInfoHandler.INSTANCE);
    }

    private static List<String> findResourcePaths(String moduleName) throws ModuleLoadException, ReflectiveOperationException, IOException, URISyntaxException {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleLoaderMXBean loader = ModuleInfoHandler.INSTANCE.getMxBean(moduleLoader);
        moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
        LinkedList<String> result = new LinkedList<String>();
        block6: for (ResourceLoaderInfo rl : loader.getResourceLoaders(moduleName)) {
            if (rl.getLocation() == null) continue;
            URL url = new URL(rl.getLocation());
            switch (url.getProtocol()) {
                case "jar": {
                    JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                    result.add(jarConnection.getJarFile().getName());
                    continue block6;
                }
            }
            result.add(new File(url.getFile()).toString());
        }
        return result;
    }

    private static final class ModuleLocationHandler
    implements OperationStepHandler {
        private ModuleLocationHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final String moduleName = MODULE_NAME.resolveModelAttribute(context, operation).asString();
                    try {
                        List<String> paths = AccessController.doPrivileged(new PrivilegedExceptionAction<List<String>>(){

                            @Override
                            public List<String> run() throws Exception {
                                return ModuleLoadingResourceDefinition.findResourcePaths(moduleName);
                            }
                        });
                        ModelNode list = context.getResult().setEmptyList();
                        for (String path : paths) {
                            list.add(path);
                        }
                    }
                    catch (PrivilegedActionException e) {
                        if (e.getCause() instanceof OperationFailedException || e.getCause() instanceof ModuleNotFoundException) {
                            throw new OperationFailedException(e.getCause());
                        }
                        throw new RuntimeException(e.getCause());
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class ListModuleRootsHandler
    extends AbstractRuntimeOnlyHandler {
        private ListModuleRootsHandler() {
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
            return false;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ModelNode list = context.getResult().setEmptyList();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ListModuleRootsHandler.storeRepoRoots(list);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof OperationFailedException || e.getCause() instanceof ModuleNotFoundException) {
                    throw new OperationFailedException(e.getCause());
                }
                throw new RuntimeException(e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void storeRepoRoots(ModelNode list) throws NoSuchFieldException, IllegalAccessException {
            ModuleLoader loader = Module.getBootModuleLoader();
            if (loader instanceof LocalModuleLoader) {
                LocalModuleLoader lml = (LocalModuleLoader)loader;
                Field findersField = ModuleLoader.class.getDeclaredField("finders");
                Field repoRootsField = null;
                findersField.setAccessible(true);
                try {
                    Object[] finders = (Object[])findersField.get(lml);
                    if (finders.length > 0 && finders[0] instanceof LocalModuleFinder) {
                        File[] repoRoots;
                        LocalModuleFinder lmf = (LocalModuleFinder)finders[0];
                        repoRootsField = LocalModuleFinder.class.getDeclaredField("repoRoots");
                        repoRootsField.setAccessible(true);
                        for (File file : repoRoots = (File[])repoRootsField.get(lmf)) {
                            list.add(file.getAbsolutePath());
                        }
                    }
                }
                finally {
                    findersField.setAccessible(false);
                    if (repoRootsField != null) {
                        repoRootsField.setAccessible(false);
                    }
                }
            }
        }
    }
}

