/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class SocketBindingService
implements Service<SocketBinding> {
    private final String name;
    private final int port;
    private final boolean isFixedPort;
    private final InetAddress multicastAddress;
    private final int multicastPort;
    private final List<ClientMapping> clientMappings;
    private SocketBinding binding;
    private final Consumer<SocketBinding> socketBindingConsumer;
    private final Supplier<NetworkInterfaceBinding> interfaceBindingSupplier;
    private final Supplier<SocketBindingManager> socketBindingsSupplier;

    public SocketBindingService(Consumer<SocketBinding> socketBindingConsumer, Supplier<NetworkInterfaceBinding> interfaceBindingSupplier, Supplier<SocketBindingManager> socketBindingsSupplier, String name, int port, boolean isFixedPort, InetAddress multicastAddress, int multicastPort, List<ClientMapping> clientMappings) {
        assert (name != null) : "name is null";
        this.socketBindingConsumer = socketBindingConsumer;
        this.interfaceBindingSupplier = interfaceBindingSupplier;
        this.socketBindingsSupplier = socketBindingsSupplier;
        this.name = name;
        this.port = port;
        this.isFixedPort = isFixedPort;
        this.multicastAddress = multicastAddress;
        this.multicastPort = multicastPort;
        this.clientMappings = clientMappings;
    }

    public synchronized void start(StartContext context) {
        this.binding = new SocketBinding(this.name, this.port, this.isFixedPort, this.multicastAddress, this.multicastPort, this.interfaceBindingSupplier != null ? this.interfaceBindingSupplier.get() : null, this.socketBindingsSupplier.get(), this.clientMappings);
        this.socketBindingConsumer.accept(this.binding);
    }

    public synchronized void stop(StopContext context) {
        this.socketBindingConsumer.accept(null);
        this.binding = null;
    }

    public synchronized SocketBinding getValue() throws IllegalStateException {
        SocketBinding binding = this.binding;
        if (binding == null) {
            throw new IllegalStateException();
        }
        return binding;
    }
}

