/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.logging.LogManager;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.selfcontained.ContentProviderServiceActivator;
import org.jboss.as.selfcontained.SelfContainedConfigurationPersister;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class SelfContainedContainer {
    public ServiceContainer start(final List<ModelNode> containerDefinition, ContentProvider contentProvider) throws ExecutionException, InterruptedException, ModuleLoadException {
        if (LogManager.getLogManager().getClass().getName().equals("org.jboss.logmanager.LogManager")) {
            try {
                Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
                StdioContext.install();
                StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
                StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
        ServerEnvironment serverEnvironment = SelfContainedContainer.determineEnvironment(WildFlySecurityManager.getSystemPropertiesPrivileged(), WildFlySecurityManager.getSystemEnvironmentPrivileged(), ServerEnvironment.LaunchType.SELF_CONTAINED);
        Bootstrap bootstrap = Bootstrap.Factory.newInstance();
        final Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
        configuration.setConfigurationPersisterFactory(new Bootstrap.ConfigurationPersisterFactory(){

            @Override
            public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                SelfContainedConfigurationPersister persister = new SelfContainedConfigurationPersister(containerDefinition);
                configuration.getExtensionRegistry().setWriterRegistry((SubsystemXmlWriterRegistry)persister);
                return persister;
            }
        });
        configuration.setModuleLoader(Module.getBootModuleLoader());
        return (ServiceContainer)bootstrap.startup(configuration, Collections.singletonList(new ContentProviderServiceActivator(contentProvider))).get();
    }

    public static ServerEnvironment determineEnvironment(Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType) {
        ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), (Map)systemProperties);
        return new ServerEnvironment(null, systemProperties, systemEnvironment, null, null, launchType, RunningMode.NORMAL, productConfig);
    }
}

