/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.ContentServitor;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.PathContentServitor;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.requestcontroller.GlobalRequestController;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;

public class DeploymentHandlerUtil {
    private DeploymentHandlerUtil() {
    }

    public static void deploy(OperationContext context, final String deploymentUnitName, final String managementName, final AbstractVaultReader vaultReader, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentModelUtils.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
                    final ServiceController deploymentController = serviceRegistry.getService(deploymentUnitServiceName);
                    if (deploymentController != null) {
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        deploymentController.addListener((ServiceListener)verificationHandler);
                        deploymentController.setMode(ServiceController.Mode.ACTIVE);
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                deploymentController.setMode(ServiceController.Mode.NEVER);
                            }
                        });
                    } else {
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        final Collection<ServiceController<?>> controllers = DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, vaultReader, contents);
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        context.completeStep(new OperationContext.ResultHandler(){

                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                    for (ServiceController controller : controllers) {
                                        context.removeService(controller.getName());
                                    }
                                    if (context.hasFailureDescription()) {
                                        ServerLogger.ROOT_LOGGER.deploymentRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                    } else {
                                        ServerLogger.ROOT_LOGGER.deploymentRolledBackWithNoMessage(deploymentUnitName);
                                    }
                                } else {
                                    ServerLogger.ROOT_LOGGER.deploymentDeployed(managementName, deploymentUnitName);
                                }
                            }
                        });
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static Collection<ServiceController<?>> doDeploy(OperationContext context, String deploymentUnitName, String managementName, ServiceVerificationHandler verificationHandler, Resource deploymentResource, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, AbstractVaultReader vaultReader, ContentItem ... contents) {
        ServiceController<VirtualFile> contentService;
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ArrayList controllers = new ArrayList();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName contentsServiceName = deploymentUnitServiceName.append(new String[]{"contents"});
        if (contents[0].hash != null) {
            contentService = ContentServitor.addService(serviceTarget, contentsServiceName, contents[0].hash, verificationHandler);
        } else {
            String path = contents[0].path;
            String relativeTo = contents[0].relativeTo;
            contentService = PathContentServitor.addService(serviceTarget, contentsServiceName, path, relativeTo, verificationHandler);
        }
        controllers.add(contentService);
        RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitName, managementName, null, registration, mutableRegistration, deploymentResource, verificationHandler, vaultReader);
        final ServiceController deploymentUnitController = serviceTarget.addService(deploymentUnitServiceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).addDependency(DeploymentMountProvider.SERVICE_NAME, DeploymentMountProvider.class, service.getServerDeploymentRepositoryInjector()).addDependency(contentsServiceName, VirtualFile.class, service.contentsInjector).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        controllers.add(deploymentUnitController);
        contentService.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                if (transition == ServiceController.Transition.REMOVING_to_REMOVED) {
                    deploymentUnitController.setMode(ServiceController.Mode.REMOVE);
                }
            }
        });
        return controllers;
    }

    public static void redeploy(OperationContext context, final String deploymentUnitName, final String managementName, final AbstractVaultReader vaultReader, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentModelUtils.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    final AtomicBoolean logged = new AtomicBoolean(false);
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                            context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, vaultReader, contents);
                            context.completeStep(new OperationContext.ResultHandler(){

                                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                    if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                        if (context.hasFailureDescription()) {
                                            ServerLogger.ROOT_LOGGER.redeployRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                            logged.set(true);
                                        } else {
                                            ServerLogger.ROOT_LOGGER.redeployRolledBackWithNoMessage(deploymentUnitName);
                                            logged.set(true);
                                        }
                                    } else {
                                        ServerLogger.ROOT_LOGGER.deploymentRedeployed(deploymentUnitName);
                                    }
                                }
                            });
                        }
                    }, OperationContext.Stage.RUNTIME, true);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, vaultReader, contents);
                            if (!logged.get()) {
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                } else {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void replace(OperationContext context, final ModelNode originalDeployment, final String deploymentUnitName, final String managementName, final String replacedDeploymentUnitName, final AbstractVaultReader vaultReader, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            PathElement path = PathElement.pathElement((String)"deployment", (String)managementName);
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            DeploymentModelUtils.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName replacedDeploymentUnitServiceName = Services.deploymentUnitName(replacedDeploymentUnitName);
                    ServiceName replacedContentsServiceName = replacedDeploymentUnitServiceName.append(new String[]{"contents"});
                    context.removeService(replacedContentsServiceName);
                    context.removeService(replacedDeploymentUnitServiceName);
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    final Collection<ServiceController<?>> controllers = DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, vaultReader, contents);
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                for (ServiceController controller : controllers) {
                                    context.removeService(controller.getName());
                                }
                                DeploymentModelUtils.cleanup(deployment);
                                String name = originalDeployment.require("name").asString();
                                String runtimeName = originalDeployment.require("runtime-name").asString();
                                ContentItem[] contents = DeploymentHandlerUtils.getContents(originalDeployment.require("content"));
                                ServiceVerificationHandler svh = new ServiceVerificationHandler();
                                DeploymentHandlerUtil.doDeploy(context, runtimeName, name, svh, deployment, registration, mutableRegistration, vaultReader, contents);
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.replaceRolledBack(replacedDeploymentUnitName, deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                } else {
                                    ServerLogger.ROOT_LOGGER.replaceRolledBackWithNoMessage(replacedDeploymentUnitName, deploymentUnitName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentReplaced(replacedDeploymentUnitName, deploymentUnitName);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void undeploy(OperationContext context, final String managementName, final String deploymentUnitName, final AbstractVaultReader vaultReader) {
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentModelUtils.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    final ServiceRegistry registry = context.getServiceRegistry(true);
                    ServiceController shutdownController = registry.getRequiredService(GlobalRequestController.SERVICE_NAME);
                    ((GlobalRequestController)shutdownController.getValue()).pauseDeployment(deploymentUnitName, null);
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                ServiceController shutdownController = registry.getRequiredService(GlobalRequestController.SERVICE_NAME);
                                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                                String name = model.require("name").asString();
                                String runtimeName = model.require("runtime-name").asString();
                                ContentItem[] contents = DeploymentHandlerUtils.getContents(model.require("content"));
                                ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                                DeploymentHandlerUtil.doDeploy(context, runtimeName, name, verificationHandler, deployment, registration, mutableRegistration, vaultReader, contents);
                                ((GlobalRequestController)shutdownController.getValue()).resumeDeployment(deploymentUnitName);
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                } else {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentUndeployed(managementName, deploymentUnitName);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static String getFormattedFailureDescription(OperationContext context) {
        ModelNode failureDescNode = context.getFailureDescription();
        String failureDesc = failureDescNode.toString();
        if (failureDesc.contains("\n") && failureDesc.charAt(0) != '\n') {
            failureDesc = "\n" + failureDesc;
        }
        return failureDesc;
    }

    static class ContentItem {
        private byte[] hash;
        private String path;
        private String relativeTo;
        private boolean isArchive;

        ContentItem(byte[] hash) {
            assert (hash != null) : "hash is null";
            this.hash = hash;
        }

        ContentItem(String path, String relativeTo, boolean isArchive) {
            assert (path != null) : "path is null";
            this.path = path;
            this.relativeTo = relativeTo;
            this.isArchive = isArchive;
        }

        byte[] getHash() {
            return this.hash;
        }
    }
}

