/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelControllerServiceInitialization;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.DomainServerCommunicationServices;
import org.jboss.as.server.GracefulShutdownService;
import org.jboss.as.server.RuntimeExpressionResolver;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentResourceDescription;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.controller.resources.VersionModelInitializer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentOverlayDeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.ServiceLoaderProcessor;
import org.jboss.as.server.deployment.SubDeploymentProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CleanupAnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndexProcessor;
import org.jboss.as.server.deployment.dependencies.DeploymentDependenciesProcessor;
import org.jboss.as.server.deployment.integration.Seam2Processor;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParsingProcessor;
import org.jboss.as.server.deployment.module.ClassFileTransformerProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootExplodedMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentVisibilityProcessor;
import org.jboss.as.server.deployment.module.DriverDependenciesProcessor;
import org.jboss.as.server.deployment.module.ManifestAttachmentProcessor;
import org.jboss.as.server.deployment.module.ManifestClassPathProcessor;
import org.jboss.as.server.deployment.module.ManifestDependencyProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionListProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleClassPathProcessor;
import org.jboss.as.server.deployment.module.ModuleDependencyProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionListProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleIdentifierProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecProcessor;
import org.jboss.as.server.deployment.module.ServerDependenciesProcessor;
import org.jboss.as.server.deployment.module.SubDeploymentDependencyProcessor;
import org.jboss.as.server.deployment.module.descriptor.DeploymentStructureDescriptorParser;
import org.jboss.as.server.deployment.reflect.CleanupReflectionIndexProcessor;
import org.jboss.as.server.deployment.reflect.InstallReflectionIndexProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorDependencyProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorProcessor;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayIndexService;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ExtensionIndexService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.requestcontroller.GlobalRequestController;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.shutdown.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public final class ServerService
extends AbstractControllerService {
    private final InjectedValue<DeploymentMountProvider> injectedDeploymentRepository = new InjectedValue();
    private final InjectedValue<ContentRepository> injectedContentRepository = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<ExternalModuleService> injectedExternalModuleService = new InjectedValue();
    private final InjectedValue<PathManager> injectedPathManagerService = new InjectedValue();
    private final Bootstrap.Configuration configuration;
    private final BootstrapListener bootstrapListener;
    private final ControlledProcessState processState;
    private final RunningModeControl runningModeControl;
    private volatile ExtensibleConfigurationPersister extensibleConfigurationPersister;
    private final AbstractVaultReader vaultReader;
    private final DelegatingResourceDefinition rootResourceDefinition;
    public static final String SERVER_NAME = "server";

    private ServerService(Bootstrap.Configuration configuration, ControlledProcessState processState, OperationStepHandler prepareStep, BootstrapListener bootstrapListener, DelegatingResourceDefinition rootResourceDefinition, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        super(ServerService.getProcessType(configuration.getServerEnvironment()), runningModeControl, null, processState, (ResourceDefinition)rootResourceDefinition, prepareStep, (ExpressionResolver)new RuntimeExpressionResolver(vaultReader), auditLogger, authorizer);
        this.configuration = configuration;
        this.bootstrapListener = bootstrapListener;
        this.processState = processState;
        this.runningModeControl = runningModeControl;
        this.vaultReader = vaultReader;
        this.rootResourceDefinition = rootResourceDefinition;
    }

    static ProcessType getProcessType(ServerEnvironment serverEnvironment) {
        if (serverEnvironment != null) {
            switch (serverEnvironment.getLaunchType()) {
                case DOMAIN: {
                    return ProcessType.DOMAIN_SERVER;
                }
                case STANDALONE: {
                    return ProcessType.STANDALONE_SERVER;
                }
                case EMBEDDED: {
                    return ProcessType.EMBEDDED_SERVER;
                }
                case APPCLIENT: {
                    return ProcessType.APPLICATION_CLIENT;
                }
            }
        }
        return ProcessType.EMBEDDED_SERVER;
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration, ControlledProcessState processState, BootstrapListener bootstrapListener, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        ThreadGroup threadGroup = new ThreadGroup("ServerService ThreadGroup");
        String namePattern = "ServerService Thread Pool -- %t";
        JBossThreadFactory threadFactory = new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "ServerService Thread Pool -- %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        ServerExecutorService serverExecutorService = new ServerExecutorService((ThreadFactory)threadFactory);
        serviceTarget.addService(Services.JBOSS_SERVER_EXECUTOR, (Service)serverExecutorService).addAliases(new ServiceName[]{ManagementRemotingServices.SHUTDOWN_EXECUTOR_NAME}).install();
        DelegatingResourceDefinition rootResourceDefinition = new DelegatingResourceDefinition();
        ServerService service = new ServerService(configuration, processState, null, bootstrapListener, rootResourceDefinition, runningModeControl, vaultReader, auditLogger, authorizer);
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)service);
        serviceBuilder.addDependency(DeploymentMountProvider.SERVICE_NAME, DeploymentMountProvider.class, service.injectedDeploymentRepository);
        serviceBuilder.addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, service.injectedContentRepository);
        serviceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        serviceBuilder.addDependency(Services.JBOSS_EXTERNAL_MODULE_SERVICE, ExternalModuleService.class, service.injectedExternalModuleService);
        serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.injectedPathManagerService);
        if (configuration.getServerEnvironment().isAllowModelControllerExecutor()) {
            serviceBuilder.addDependency(Services.JBOSS_SERVER_EXECUTOR, ExecutorService.class, (Injector)service.getExecutorServiceInjector());
        }
        serviceBuilder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
        if (this.runningModeControl.isReloaded()) {
            // empty if block
        }
        Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = this.configuration.getConfigurationPersisterFactory();
        this.extensibleConfigurationPersister = configurationPersisterFactory.createConfigurationPersister(serverEnvironment, (ExecutorService)this.getExecutorServiceInjector().getOptionalValue());
        this.setConfigurationPersister((ConfigurationPersister)this.extensibleConfigurationPersister);
        this.rootResourceDefinition.setDelegate((ResourceDefinition)new ServerRootResourceDefinition((ContentRepository)this.injectedContentRepository.getValue(), this.extensibleConfigurationPersister, this.configuration.getServerEnvironment(), this.processState, this.runningModeControl, this.vaultReader, this.configuration.getExtensionRegistry(), this.getExecutorServiceInjector().getOptionalValue() != null, (PathManagerService)this.injectedPathManagerService.getValue(), new DomainServerCommunicationServices.OperationIDUpdater(){

            @Override
            public void updateOperationID(int operationID) {
                DomainServerCommunicationServices.updateOperationID(operationID);
            }
        }, this.authorizer, super.getAuditLogger()));
        super.start(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        boolean ok;
        try {
            ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
            ServiceTarget serviceTarget = context.getServiceTarget();
            File[] extDirs = serverEnvironment.getJavaExtDirs();
            File[] newExtDirs = Arrays.copyOf(extDirs, extDirs.length + 1);
            newExtDirs[extDirs.length] = new File(serverEnvironment.getServerBaseDir(), "lib/ext");
            serviceTarget.addService(org.jboss.as.server.deployment.Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX, (Service)new ExtensionIndexService(newExtDirs)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            this.runPerformControllerInitialization(context);
            DeploymentOverlayIndexService deploymentOverlayIndexService = new DeploymentOverlayIndexService();
            context.getServiceTarget().addService(DeploymentOverlayIndexService.SERVICE_NAME, (Service)deploymentOverlayIndexService).install();
            context.getServiceTarget().addService(SuspendController.SERVICE_NAME, (Service)new SuspendController()).install();
            GracefulShutdownService gracefulShutdownService = new GracefulShutdownService();
            context.getServiceTarget().addService(GracefulShutdownService.SERVICE_NAME, (Service)gracefulShutdownService).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, gracefulShutdownService.getSuspendControllerInjectedValue()).install();
            GlobalRequestController globalRequestController = new GlobalRequestController();
            context.getServiceTarget().addService(GlobalRequestController.SERVICE_NAME, (Service)globalRequestController).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, globalRequestController.getShutdownControllerInjectedValue()).install();
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 4096, new DeploymentUnitProcessor(){

                @Override
                public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.SERVICE_MODULE_LOADER, ServerService.this.injectedModuleLoader.getValue());
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.EXTERNAL_MODULE_SERVICE, ServerService.this.injectedExternalModuleService.getValue());
                }

                @Override
                public void undeploy(DeploymentUnit context) {
                    context.removeAttachment(Attachments.SERVICE_MODULE_LOADER);
                }
            });
            HttpListenerRegistryService.install((ServiceTarget)serviceTarget);
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 256, new DeploymentRootExplodedMountProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 512, new DeploymentRootMountProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 768, new ManifestAttachmentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 5632, new ManifestAttachmentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 640, new DeploymentOverlayDeploymentUnitProcessor(deploymentOverlayIndexService));
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 5888, new SubDeploymentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 6656, new ModuleIdentifierProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 4352, new AnnotationIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 2784, new JBossAllXMLParsingProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 6272, new DeploymentStructureDescriptorParser());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 6400, new ManifestClassPathProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 7424, new DeploymentDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 768, new ManifestDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 769, new CompositeIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 1792, new ManifestExtensionListProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 2048, new ManifestExtensionNameProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 8704, new ServiceLoaderProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 768, new ModuleDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 1536, new ServiceActivatorDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 2048, new ModuleClassPathProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 2304, new ModuleExtensionListProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 3584, new SubDeploymentDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 4608, new ServerDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 8448, new DeploymentVisibilityProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 5888, new DriverDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.CONFIGURE_MODULE, 512, new ModuleSpecProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.POST_MODULE, 2560, new ModuleExtensionNameProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.POST_MODULE, 512, new InstallReflectionIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.FIRST_MODULE_USE, 1280, new ClassFileTransformerProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.INSTALL, 1280, new ServiceActivatorProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.INSTALL, 8448, new DeploymentCompleteServiceProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.CLEANUP, 256, new CleanupReflectionIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.CLEANUP, 1024, new CleanupAnnotationIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 2561, new Seam2Processor(serviceTarget));
            DeploymentStructureDescriptorParser.registerJBossXMLParsers();
            DeploymentDependenciesProcessor.registerJBossXMLParsers();
            try {
                boolean failOnRuntime = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.unsupported.fail-boot-on-runtime-failure", (String)"false"));
                ok = this.boot(this.extensibleConfigurationPersister.load(), failOnRuntime);
                if (ok) {
                    this.finishBoot();
                }
            }
            finally {
                DeployerChainAddHandler.INSTANCE.clearDeployerMap();
            }
        }
        catch (Exception e) {
            ServerLogger.ROOT_LOGGER.caughtExceptionDuringBoot(e);
            ok = false;
        }
        if (ok) {
            this.bootstrapListener.printBootStatistics();
        } else {
            ServerLogger.ROOT_LOGGER.unsuccessfulBoot();
            System.exit(1);
        }
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        ArrayList<ModelNode> operations = new ArrayList<ModelNode>(bootOperations);
        operations.add(DeployerChainAddHandler.OPERATION);
        return super.boot(operations, rollbackOnRuntimeFailure);
    }

    public void stop(StopContext context) {
        this.configuration.getExtensionRegistry().clear();
        this.configuration.getServerEnvironment().resetProvidedProperties();
        super.stop(context);
    }

    protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration, Resource modelControllerResource) {
        Resource managementResource = Resource.Factory.create();
        managementResource.registerChild(PathElement.pathElement((String)"service", (String)"management-operations"), modelControllerResource);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"management"), managementResource);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"service-container"), Resource.Factory.create());
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"module-loading"), Resource.Factory.create());
        managementResource.registerChild(AccessAuthorizationResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.createResource((AccessConstraintUtilizationRegistry)this.authorizer.getWritableAuthorizerConfiguration()));
        rootResource.registerChild(ServerEnvironmentResourceDescription.RESOURCE_PATH, Resource.Factory.create());
        ((PathManagerService)this.injectedPathManagerService.getValue()).addPathManagerResources(rootResource);
        VersionModelInitializer.registerRootResource(rootResource, this.configuration.getServerEnvironment() != null ? this.configuration.getServerEnvironment().getProductConfig() : null);
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
    }

    protected void performControllerInitialization(ServiceTarget target, Resource rootResource, ManagementResourceRegistration rootRegistration) {
        ServiceLoader<ModelControllerServiceInitialization> sl = ServiceLoader.load(ModelControllerServiceInitialization.class);
        for (ModelControllerServiceInitialization init : sl) {
            init.initializeStandalone(target, rootRegistration, rootResource);
        }
    }

    private static class DelegatingResourceDefinition
    implements ResourceDefinition {
        private volatile ResourceDefinition delegate;

        private DelegatingResourceDefinition() {
        }

        void setDelegate(ResourceDefinition delegate) {
            this.delegate = delegate;
        }

        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerOperations(resourceRegistration);
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerChildren(resourceRegistration);
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerAttributes(resourceRegistration);
        }

        public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerNotifications(resourceRegistration);
        }

        public PathElement getPathElement() {
            return this.delegate.getPathElement();
        }

        public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
            return this.delegate.getDescriptionProvider(resourceRegistration);
        }

        public List<AccessConstraintDefinition> getAccessConstraints() {
            if (this.delegate == null) {
                return Collections.emptyList();
            }
            return this.delegate.getAccessConstraints();
        }
    }

    private static class ServerExecutorService
    implements Service<ExecutorService> {
        private final ThreadFactory threadFactory;
        private ExecutorService executorService;

        private ServerExecutorService(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public synchronized void start(StartContext context) throws StartException {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory);
        }

        public synchronized void stop(final StopContext context) {
            if (this.executorService != null) {
                context.asynchronous();
                Thread executorShutdown = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ServerExecutorService.this.executorService.shutdown();
                        }
                        finally {
                            ServerExecutorService.this.executorService = null;
                            context.complete();
                        }
                    }
                }, "ServerExecutorService Shutdown Thread");
                executorShutdown.start();
            }
        }

        public synchronized ExecutorService getValue() throws IllegalStateException, IllegalArgumentException {
            return this.executorService;
        }
    }
}

