/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.logging;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYSRV", length=4)
public interface ServerLogger
extends BasicLogger {
    public static final ServerLogger ROOT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server");
    public static final ServerLogger AS_ROOT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as");
    public static final ServerLogger CONFIG_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.config");
    public static final ServerLogger FD_LIMIT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.warn.fd-limit");
    public static final ServerLogger DEPLOYMENT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server.deployment");
    public static final ServerLogger PRIVATE_DEP_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.dependency.private");
    public static final ServerLogger UNSUPPORTED_DEP_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.dependency.unsupported");
    public static final ServerLogger MODULE_SERVICE_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server.moduleservice");
    public static final ServerLogger NETWORK_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server.net");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="%s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.")
    public void jbossDeploymentStructureIgnored(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Could not read provided index: %s")
    public void cannotLoadAnnotationIndex(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Could not index class %s at %s")
    public void cannotIndexClass(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Undeploy of deployment \"%s\" was rolled back with the following failure message: %s")
    public void undeploymentRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Undeploy of deployment \"%s\" was rolled back with no failure message")
    public void undeploymentRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Undeployed \"%s\" (runtime-name: \"%s\")")
    public void deploymentUndeployed(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Deployed \"%s\" (runtime-name : \"%s\")")
    public void deploymentDeployed(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="Redeploy of deployment \"%s\" was rolled back with the following failure message: %s")
    public void redeployRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="Redeploy of deployment \"%s\" was rolled back with no failure message")
    public void redeployRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Redeployed \"%s\"")
    public void deploymentRedeployed(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with the following failure message: %s")
    public void replaceRolledBack(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15, value="Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with no failure message")
    public void replaceRolledBackWithNoMessage(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Replaced deployment \"%s\" with deployment \"%s\"")
    public void deploymentReplaced(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Annotations import option %s specified in jboss-deployment-structure.xml for additional module %s has been ignored. Additional modules cannot import annotations.")
    public void annotationImportIgnored(ModuleIdentifier var1, ModuleIdentifier var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Deployment \"%s\" is using a private module (\"%s\") which may be changed or removed in future versions without notice.")
    public void privateApiUsed(String var1, ModuleIdentifier var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Deployment \"%s\" is using an unsupported module (\"%s\") which may be changed or removed in future versions without notice.")
    public void unsupportedApiUsed(String var1, ModuleIdentifier var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Exception occurred removing deployment content %s")
    public void failedToRemoveDeploymentContent(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="Deploy of deployment \"%s\" was rolled back with the following failure message: %s")
    public void deploymentRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22, value="Deploy of deployment \"%s\" was rolled back with no failure message")
    public void deploymentRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23, value="Failed to parse property (%s), value (%s) as an integer")
    public void failedToParseCommandLineInteger(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=24, value="Cannot add module '%s' as URLStreamHandlerFactory provider")
    public void cannotAddURLStreamHandlerFactory(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=25, value="%s started in %dms - Started %d of %d services (%d services are lazy, passive or on-demand)")
    public void startedClean(String var1, long var2, int var4, int var5, int var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="%s started (with errors) in %dms - Started %d of %d services (%d services failed or missing dependencies, %d services are lazy, passive or on-demand)")
    public void startedWitErrors(String var1, long var2, int var4, int var5, int var6, int var7);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Starting deployment of \"%s\" (runtime-name: \"%s\")")
    public void startingDeployment(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Stopped deployment %s (runtime-name: %s) in %dms")
    public void stoppedDeployment(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=33, value="%s caught exception attempting to revert operation %s at address %s")
    public void caughtExceptionRevertingOperation(@Cause Exception var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=34, value="No security realm defined for native management service; all access will be unrestricted.")
    public void nativeManagementInterfaceIsUnsecured();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="No security realm defined for http management service; all access will be unrestricted.")
    public void httpManagementInterfaceIsUnsecured();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=36, value="Creating http management service using network interface (%s) and port (%d)")
    public void creatingHttpManagementServiceOnPort(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=37, value="Creating http management service using network interface (%s) and secure port (%d)")
    public void creatingHttpManagementServiceOnSecurePort(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=38, value="Creating http management service using network interface (%s), port (%d) and secure port (%d)")
    public void creatingHttpManagementServiceOnPortAndSecurePort(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=39, value="Creating http management service using socket-binding (%s)")
    public void creatingHttpManagementServiceOnSocket(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=40, value="Creating http management service using secure-socket-binding (%s)")
    public void creatingHttpManagementServiceOnSecureSocket(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=41, value="Creating http management service using socket-binding (%s) and secure-socket-binding (%s)")
    public void creatingHttpManagementServiceOnSocketAndSecureSocket(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=42, value="Caught exception closing input stream for uploaded deployment content")
    public void caughtExceptionClosingContentInputStream(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=43, value="Deployment unit processor %s unexpectedly threw an exception during undeploy phase %s of %s")
    public void caughtExceptionUndeploying(@Cause Throwable var1, DeploymentUnitProcessor var2, Phase var3, DeploymentUnit var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=44, value="Module %s will not have it's annotations processed as no %s file was found in the deployment. Please generate this file using the Jandex ant task.")
    public void noCompositeIndex(ModuleIdentifier var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=45, value="Extension %s is missing the required manifest attribute %s-%s (skipping extension)")
    public void extensionMissingManifestAttribute(String var1, String var2, Attributes.Name var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=46, value="Extension %s URI syntax is invalid: %s")
    public void invalidExtensionURI(String var1, URISyntaxException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=47, value="Could not find Extension-List entry %s referenced from %s")
    public void cannotFindExtensionListEntry(ExtensionListEntry var1, ResourceRoot var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=48, value="A server name configuration was provided both via system property %s ('%s') and via the xml configuration ('%s'). The xml configuration value will be used.")
    public void duplicateServerNameConfiguration(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=49, value="%s starting")
    public void serverStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=50, value="%s stopped in %dms")
    public void serverStopped(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=51, value="Admin console listening on http://%s:%d")
    public void logHttpConsole(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=52, value="Admin console listening on https://%s:%d")
    public void logHttpsConsole(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=53, value="Admin console listening on http://%s:%d and https://%s:%d")
    public void logHttpAndHttpsConsole(String var1, int var2, String var3, int var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=54, value="Admin console is not enabled")
    public void logNoConsole();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=55, value="Caught exception during boot")
    public void caughtExceptionDuringBoot(@Cause Exception var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=56, value="Server boot has failed in an unrecoverable manner; exiting. See previous messages for details.")
    public void unsuccessfulBoot();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=57, value="No deployment content with hash %s is available in the deployment content repository for deployment %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.")
    public void reportAdminOnlyMissingDeploymentContent(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=58, value="Additional resource root %s added via jboss-deployment-structure.xml does not exist")
    public void additionalResourceRootDoesNotExist(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=59, value="Class Path entry %s in %s  does not point to a valid jar for a Class-Path reference.")
    public void classPathEntryNotValid(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=60, value="Http management interface listening on http://%s:%d/management")
    public void logHttpManagement(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=61, value="Http management interface listening on https://%s:%d/management")
    public void logHttpsManagement(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=62, value="Http management interface listening on http://%s:%d/management and https://%s:%d/management")
    public void logHttpAndHttpsManagement(String var1, int var2, String var3, int var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=63, value="Http management interface is not enabled")
    public void logNoHttpManagement();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=64, value="urn:jboss:deployment-structure namespace found in jboss.xml for a sub deployment %s. This is only valid in a top level deployment.")
    public void jbossDeploymentStructureNamespaceIgnored(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=65, value="Failed to unmount deployment overlay")
    public void failedToUnmountContentOverride(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=67, value="jboss-deployment-dependencies cannot be used in a sub deployment, it must be specified at ear level: %s")
    public void deploymentDependenciesAreATopLevelElement(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=68, value="No deployment overlay content with hash %s is available in the deployment content repository for deployment %s at location %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.")
    public void reportAdminOnlyMissingDeploymentOverlayContent(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=69, value="Defer %s for %s making it %s")
    public void infoDeferDeploymentPhase(Phase var1, String var2, ServiceController.Mode var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=70, value="Deployment restart detected for deployment %s, performing full redeploy instead.")
    public void deploymentRestartDetected(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=71, value="The operating system has limited the number of open files to %d for this process; a value of at least 4096 is recommended")
    public void fdTooLow(long var1);

    @Message(id=0, value="Name of the server configuration file to use (default is \"standalone.xml\") (Same as -c)")
    public String argServerConfig();

    @Message(id=0, value="Name of the server configuration file to use (default is \"standalone.xml\") (Same as --server-config)")
    public String argShortServerConfig();

    @Message(id=0, value="Name of the server configuration file to use. This differs from '--server-config' and '-c' in that the original file is never overwritten.")
    public String argReadOnlyServerConfig();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set a security property")
    public String argSecurityProperty();

    @Message(id=0, value="Set a system property")
    public String argSystem();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Set system property jboss.bind.address to the given value")
    public String argPublicBindAddress();

    @Message(id=0, value="Set system property jboss.bind.address.<interface> to the given value")
    public String argInterfaceBindAddress();

    @Message(id=0, value="Set system property jboss.default.multicast.address to the given value")
    public String argDefaultMulticastAddress();

    @Message(id=0, value="Set the server's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start other runtime services or accept end user requests.")
    public String argAdminOnly();

    @Message(id=0, value="Activate debug mode with an optional argument to specify the port. Only works if the launch script supports it.")
    public String argDebugPort();

    @Message(id=0, value="Runs the server with a security manager installed.")
    public String argSecMgr();

    @Message(id=72, value="Value expected for option %s")
    public String valueExpectedForCommandLineOption(String var1);

    @Message(id=73, value="Invalid option '%s'")
    public String invalidCommandLineOption(String var1);

    @Message(id=74, value="Malformed URL '%s' provided for option '%s'")
    public String malformedCommandLineURL(String var1, String var2);

    @Message(id=75, value="Unable to load properties from URL '%s'")
    public String unableToLoadProperties(URL var1);

    @Message(id=76, value="Error initializing vault --  %s")
    public RuntimeException cannotCreateVault(@Param VaultReaderException var1, VaultReaderException var2);

    @Message(id=79, value="hostControllerName must be null if the server is not in a managed domain")
    public IllegalArgumentException hostControllerNameNonNullInStandalone();

    @Message(id=80, value="hostControllerName may not be null if the server is in a managed domain")
    public IllegalArgumentException hostControllerNameNullInDomain();

    @Message(id=81, value="An IP address cannot be resolved using the given interface selection criteria. Failure was -- %s")
    public OperationFailedException cannotResolveInterface(Exception var1, @Param Exception var2);

    @Message(id=82, value="failed to resolve interface %s")
    public StartException failedToResolveInterface(String var1);

    @Message(id=83, value="Failed to start the http-interface service")
    public StartException failedToStartHttpManagementService(@Param Exception var1);

    @Message(id=84, value="No deployment content with hash %s is available in the deployment content repository.")
    public OperationFailedException noSuchDeploymentContent(String var1);

    @Message(id=85, value="No deployment with name %s found")
    public OperationFailedException noSuchDeployment(String var1);

    @Message(id=86, value="Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.")
    public OperationFailedException cannotReplaceDeployment(String var1, String var2, String var3, String var4, String var5);

    @Message(id=87, value="Deployment %s is already started")
    public OperationFailedException deploymentAlreadyStarted(String var1);

    @Message(id=88, value="Missing configuration value for: %s")
    public IllegalStateException missingHomeDirConfiguration(String var1);

    @Message(id=90, value="%s is required")
    public OperationFailedException attributeIsRequired(String var1);

    @Message(id=91, value="%s is not allowed when %s are present")
    public OperationFailedException attributeNotAllowedWhenAlternativeIsPresent(String var1, List<String> var2);

    @Message(id=92, value="%s is invalid")
    public OperationFailedException attributeIsInvalid(String var1);

    @Message(id=93, value="Caught IOException reading uploaded deployment content")
    public OperationFailedException caughtIOExceptionUploadingContent(@Cause IOException var1);

    @Message(id=94, value="Null stream at index [%d]")
    public OperationFailedException nullStreamAttachment(int var1);

    @Message(id=95, value="'%s' is not a valid URL")
    public OperationFailedException invalidDeploymentURL(String var1, @Cause MalformedURLException var2);

    @Message(id=96, value="Error obtaining input stream from URL '%s'")
    public OperationFailedException problemOpeningStreamFromDeploymentURL(String var1, @Cause IOException var2);

    @Message(id=97, value="ServiceModuleLoader already started")
    public IllegalStateException serviceModuleLoaderAlreadyStarted();

    @Message(id=98, value="ServiceModuleLoader already stopped")
    public IllegalStateException serviceModuleLoaderAlreadyStopped();

    @Message(id=99, value="'%s' cannot be loaded from a ServiceModuleLoader as its name does not start with '%s'")
    public IllegalArgumentException missingModulePrefix(ModuleIdentifier var1, String var2);

    @Message(id=100, value="Failed to read '%s'")
    public DeploymentUnitProcessingException failedToReadVirtualFile(VirtualFile var1, @Cause IOException var2);

    @Message(id=101, value="Deployment root is required")
    public IllegalArgumentException deploymentRootRequired();

    @Message(id=102, value="Sub-deployments require a parent deployment unit")
    public IllegalArgumentException subdeploymentsRequireParent();

    @Message(id=103, value="No Module Identifier attached to deployment '%s'")
    public DeploymentUnitProcessingException noModuleIdentifier(String var1);

    @Message(id=104, value="Failed to create VFSResourceLoader for root [%s]")
    public DeploymentUnitProcessingException failedToCreateVFSResourceLoader(String var1, @Cause IOException var2);

    @Message(id=105, value="Failed to get file from remote repository")
    public RuntimeException failedToGetFileFromRemoteRepository(@Cause Throwable var1);

    @Message(id=106, value="Unable to create local directory: %s")
    public IOException cannotCreateLocalDirectory(File var1);

    @Message(id=107, value="Did not read the entire file. Missing: %d")
    public IOException didNotReadEntireFile(long var1);

    @Message(id=108, value="No value was provided for argument %s%n")
    public String noArgValue(String var1);

    @Message(id=109, value="Could not find the file repository connection to the host controller.")
    public IllegalStateException couldNotFindHcFileRepositoryConnection();

    @Message(id=112, value="Unknown mount type %s")
    public IllegalArgumentException unknownMountType(MountType var1);

    @Message(id=113, value="Failed to create temp file provider")
    public StartException failedCreatingTempProvider();

    @Message(id=114, value="%s cannot be defined when either %s or %s is also defined")
    public OperationFailedException illegalCombinationOfHttpManagementInterfaceConfigurations(String var1, String var2, String var3);

    @Message(id=115, value="System property %s cannot be set via the xml configuration file or from a management client; it's value must be known at initial process start so it can only set from the commmand line")
    public OperationFailedException systemPropertyNotManageable(String var1);

    @Message(id=116, value="System property %s cannot be set after the server name has been set via the xml configuration file or from a management client")
    public OperationFailedException systemPropertyCannotOverrideServerName(String var1);

    @Message(id=117, value="Unable to initialise a basic SSLContext '%s'")
    public IOException unableToInitialiseSSLContext(String var1);

    @Message(id=118, value="Determined modules directory does not exist: %s")
    public IllegalStateException modulesDirectoryDoesNotExist(File var1);

    @Message(id=119, value="Home directory does not exist: %s")
    public IllegalStateException homeDirectoryDoesNotExist(File var1);

    @Message(id=120, value="Bundles directory does not exist: %s")
    public IllegalStateException bundlesDirectoryDoesNotExist(File var1);

    @Message(id=121, value="Configuration directory does not exist: %s")
    public IllegalStateException configDirectoryDoesNotExist(File var1);

    @Message(id=122, value="Server base directory does not exist: %s")
    public IllegalStateException serverBaseDirectoryDoesNotExist(File var1);

    @Message(id=123, value="Server data directory is not a directory: %s")
    public IllegalStateException serverDataDirectoryIsNotDirectory(File var1);

    @Message(id=124, value="Could not create server data directory: %s")
    public IllegalStateException couldNotCreateServerDataDirectory(File var1);

    @Message(id=125, value="Server content directory is not a directory: %s")
    public IllegalStateException serverContentDirectoryIsNotDirectory(File var1);

    @Message(id=126, value="Could not create server content directory: %s")
    public IllegalStateException couldNotCreateServerContentDirectory(File var1);

    @Message(id=127, value="Log directory is not a directory: %s")
    public IllegalStateException logDirectoryIsNotADirectory(File var1);

    @Message(id=128, value="Could not create log directory: %s")
    public IllegalStateException couldNotCreateLogDirectory(File var1);

    @Message(id=129, value="Server temp directory does not exist: %s")
    public IllegalStateException serverTempDirectoryIsNotADirectory(File var1);

    @Message(id=130, value="Could not create server temp directory: %s")
    public IllegalStateException couldNotCreateServerTempDirectory(File var1);

    @Message(id=131, value="Controller temp directory does not exist: %s")
    public IllegalStateException controllerTempDirectoryIsNotADirectory(File var1);

    @Message(id=132, value="Could not create server temp directory: %s")
    public IllegalStateException couldNotCreateControllerTempDirectory(File var1);

    @Message(id=133, value="Domain base dir does not exist: %s")
    public IllegalStateException domainBaseDirDoesNotExist(File var1);

    @Message(id=134, value="Domain config dir does not exist: %s")
    public IllegalStateException domainConfigDirDoesNotExist(File var1);

    @Message(id=135, value="Server base directory is not a directory: %s")
    public IllegalStateException serverBaseDirectoryIsNotADirectory(File var1);

    @Message(id=136, value="Could not create server base directory: %s")
    public IllegalStateException couldNotCreateServerBaseDirectory(File var1);

    @Message(id=137, value="No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuration file and restart.")
    public OperationFailedException noSuchDeploymentContentAtBoot(String var1, String var2);

    @Message(id=0, value="Configured system properties:")
    public String configuredSystemPropertiesLabel();

    @Message(id=0, value="VM Arguments: %s")
    public String vmArgumentsLabel(String var1);

    @Message(id=0, value="Configured system environment:")
    public String configuredSystemEnvironmentLabel();

    @Message(id=138, value="VFS is not available from the configured module loader")
    public IllegalStateException vfsNotAvailable();

    @Message(id=139, value="Server controller service was removed")
    public ServiceNotFoundException serverControllerServiceRemoved();

    @Message(id=140, value="Root service was removed")
    public IllegalStateException rootServiceRemoved();

    @Message(id=141, value="Cannot start server")
    public IllegalStateException cannotStartServer(@Cause Exception var1);

    @Message(id=142, value="Naming context has not been set")
    public IllegalStateException namingContextHasNotBeenSet();

    @Message(id=143, value="No directory called '%s' exists under '%s'")
    public IllegalArgumentException embeddedServerDirectoryNotFound(String var1, String var2);

    @Message(id=144, value="-D%s=%s does not exist")
    public IllegalArgumentException propertySpecifiedFileDoesNotExist(String var1, String var2);

    @Message(id=145, value="-D%s=%s is not a directory")
    public IllegalArgumentException propertySpecifiedFileIsNotADirectory(String var1, String var2);

    @Message(id=146, value="Error copying '%s' to '%s'")
    public RuntimeException errorCopyingFile(String var1, String var2, @Cause IOException var3);

    @Message(id=147, value="%s is null")
    public InvalidObjectException invalidObject(String var1);

    @Message(id=148, value="portOffset is out of range")
    public InvalidObjectException invalidPortOffset();

    @Message(id=149, value="Invalid '%s' value: %d, the maximum index is %d")
    public OperationFailedException invalidStreamIndex(String var1, int var2, int var3);

    @Message(id=150, value="Cannot create input stream from URL '%s'")
    public OperationFailedException invalidStreamURL(@Cause Exception var1, String var2);

    @Message(id=151, value="No bytes available at param %s")
    public OperationFailedException invalidStreamBytes(String var1);

    @Message(id=152, value="Only 1 piece of content is current supported (AS7-431)")
    public OperationFailedException multipleContentItemsNotSupported();

    @Message(id=153, value="Failed to process phase %s of %s")
    public StartException deploymentPhaseFailed(Phase var1, DeploymentUnit var2, @Cause Throwable var3);

    @Message(id=154, value="Null initial deployment unit")
    public IllegalArgumentException nullInitialDeploymentUnit();

    @Message(id=155, value="Attachment key is null")
    public IllegalArgumentException nullAttachmentKey();

    @Message(id=156, value="Failed to index deployment root for annotations")
    public DeploymentUnitProcessingException deploymentIndexingFailed(@Cause Throwable var1);

    @Message(id=157, value="No Seam Integration jar present: %s")
    public DeploymentUnitProcessingException noSeamIntegrationJarPresent(Module var1);

    @Message(id=158, value="Failed to instantiate a %s")
    public DeploymentUnitProcessingException failedToInstantiateClassFileTransformer(String var1, @Cause Exception var2);

    @Message(id=159, value="No deployment repository available.")
    public DeploymentUnitProcessingException noDeploymentRepositoryAvailable();

    @Message(id=160, value="Failed to mount deployment content")
    public DeploymentUnitProcessingException deploymentMountFailed(@Cause IOException var1);

    @Message(id=161, value="Failed to get manifest for deployment %s")
    public DeploymentUnitProcessingException failedToGetManifest(VirtualFile var1, @Cause IOException var2);

    @Message(id=163, value="Cannot merge resource root for a different file. This: %s mergee: %s")
    public IllegalArgumentException cannotMergeResourceRoot(VirtualFile var1, VirtualFile var2);

    @Message(id=164, value="Failed to create temp file provider")
    public RuntimeException failedToCreateTempFileProvider(@Cause IOException var1);

    @Message(id=165, value="Resource is too large to be a valid class file")
    public IOException resourceTooLarge();

    @Message(id=166, value="Sub deployment %s in jboss-deployment-structure.xml was not found. Available sub deployments: %s")
    public DeploymentUnitProcessingException subdeploymentNotFound(String var1, StringBuilder var2);

    @Message(id=167, value="No jboss-deployment-structure.xml file found at %s")
    public DeploymentUnitProcessingException deploymentStructureFileNotFound(File var1);

    @Message(id=168, value="Error loading jboss-deployment-structure.xml from %s")
    public DeploymentUnitProcessingException errorLoadingDeploymentStructureFile(String var1, @Cause XMLStreamException var2);

    @Message(id=169, value="Sub deployment '%s' is listed twice in jboss-deployment-structure.xml")
    public XMLStreamException duplicateSubdeploymentListing(String var1);

    @Message(id=170, value="Additional module name '%s' is not valid. Names must start with 'deployment.'")
    public XMLStreamException invalidModuleName(String var1);

    @Message(id=171, value="External resource roots not supported, resource roots may not start with a '/' : %s")
    public XMLStreamException externalResourceRootsNotSupported(String var1);

    @Message(id=172, value="Unexpected end of document")
    public XMLStreamException unexpectedEndOfDocument(@Param Location var1);

    @Message(id=173, value="Missing one or more required attributes:%s")
    public XMLStreamException missingRequiredAttributes(String var1, @Param Location var2);

    @Message(id=174, value="Unexpected content of type '%s', name is '%s', text is: '%s'")
    public XMLStreamException unexpectedContent(String var1, QName var2, String var3, @Param Location var4);

    @Message(id=175, value="No method found with id: %s on class (or its super class) %s")
    public DeploymentUnitProcessingException noMethodFound(MethodIdentifier var1, Class<?> var2);

    @Message(id=176, value="Method cannot be null")
    public IllegalArgumentException nullMethod();

    @Message(id=177, value="Error getting reflective information for %s with ClassLoader %s")
    public RuntimeException errorGettingReflectiveInformation(Class<?> var1, ClassLoader var2, @Param Throwable var3);

    @Message(id=178, value="External Module Service already started")
    public IllegalStateException externalModuleServiceAlreadyStarted();

    @Message(id=179, value="Failed to load module: %s")
    public StartException failedToLoadModule(ModuleIdentifier var1, @Cause ModuleLoadException var2);

    @Message(id=181, value="%s cannot be defined when %s is also defined")
    public OperationFailedException conflictingConfigs(String var1, String var2);

    @Message(id=182, value="This operation is for internal use only")
    public OperationFailedException internalUseOnly();

    @Message(id=183, value="Was not able to get root resource")
    public RuntimeException cannotGetRootResource();

    @Message(id=187, value="Failed to get multicast address for %s")
    public OperationFailedException failedToResolveMulticastAddress(@Cause UnknownHostException var1, String var2);

    @Message(id=188, value="Failed to get multicast address for %s")
    public RuntimeException failedToResolveMulticastAddressForRollback(@Cause UnknownHostException var1, String var2);

    @Message(id=190, value="Cannot add more than one socket binding group. Add of '%s' attempted, but '%s' already exists")
    public OperationFailedException cannotAddMoreThanOneSocketBindingGroupForServer(PathAddress var1, PathAddress var2);

    @Message(id=191, value="Can't use both --server-config and --initial-server-config")
    public IllegalArgumentException cannotHaveBothInitialServerConfigAndServerConfig();

    @Message(id=192, value="Duplicate namespace %s in jboss-all.xml")
    public XMLStreamException duplicateJBossXmlNamespace(QName var1, @Param Location var2);

    @Message(id=193, value="Two different versions of the same namespaces are present in jboss-all.xml, %s and %s are both present")
    public DeploymentUnitProcessingException equivalentNamespacesInJBossXml(QName var1, QName var2);

    @Message(id=194, value="Error loading jboss-all.xml from %s")
    public DeploymentUnitProcessingException errorLoadingJBossXmlFile(String var1, @Cause XMLStreamException var2);

    @Message(id=195, value="Cannot obtain required module for: %s")
    public IllegalStateException nullModuleAttachment(DeploymentUnit var1);

    @Message(id=196, value="Failed to get content for deployment overlay %s at %s")
    public DeploymentUnitProcessingException deploymentOverlayFailed(@Cause Exception var1, String var2, String var3);

    @Message(id=198, value="No deployment overlay content with hash %s is available in the deployment content repository for deployment overlay '%s' at location %s. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment overlay from the xml configuration file and restart.")
    public OperationFailedException noSuchDeploymentOverlayContentAtBoot(String var1, String var2, String var3);

    @Message(id=199, value="No deployment overlay content with hash %s is available in the deployment content repository.")
    public OperationFailedException noSuchDeploymentOverlayContent(String var1);

    @Message(id=200, value="Failed to read file %s")
    public OperationFailedException failedToLoadFile(VirtualFile var1, @Cause IOException var2);

    @Message(id=201, value="Cannot have more than one of %s")
    public OperationFailedException cannotHaveMoreThanOneManagedContentItem(Set<String> var1);

    @Message(id=202, value="Unknown content item key: %s")
    public OperationFailedException unknownContentItemKey(String var1);

    @Message(id=203, value="Cannot use %s when %s are used")
    public OperationFailedException cannotMixUnmanagedAndManagedContentItems(Set<String> var1, Set<String> var2);

    @Message(id=204, value="Null '%s'")
    public OperationFailedException nullParameter(String var1);

    @Message(id=205, value="There is already a deployment called %s with the same runtime name %s")
    public OperationFailedException runtimeNameMustBeUnique(String var1, String var2);

    @Message(id=206, value="Multiple deployment unit processors registered with priority %s and class %s")
    public IllegalStateException duplicateDeploymentUnitProcessor(int var1, Class var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=207, value="Starting subdeployment (runtime-name: \"%s\")")
    public void startingSubDeployment(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=208, value="Stopped subdeployment (runtime-name: %s) in %dms")
    public void stoppedSubDeployment(String var1, int var2);

    @Message(id=209, value="When specifying a 'module' you also need to specify the 'code'")
    public OperationFailedException vaultModuleWithNoCode();

    @Message(id=210, value="Server is already paused")
    public IllegalStateException serverAlreadyPaused();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=211, value="Suspending server")
    public void suspendingServer();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=212, value="Resuming server")
    public void resumingServer();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=213, value="Failed to connect to host-controller, retrying.")
    public void failedToConnectToHostController();

    @Message(id=214, value="For a secure port to be enabled for the HTTP management interface a security realm to supply the SSLContext must be specified.")
    public OperationFailedException noSecurityRealmForSsl();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=215, value="Failed to resume activity %s. To resume normal operation it is recommended that you restart the server.")
    public void failedToResume(ServerActivity var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=216, value="Error cleaning obsolete content %s ")
    public void failedToCleanObsoleteContent(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=217, value="Error cleaning obsolete content")
    public void failedToCleanObsoleteContent(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=218, value="Error stopping content repository cleaner")
    public void failedToStopRepositoryCleaner(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=219, value="%s deployment has been re-deployed, its content will not be removed. You will need to restart it.")
    public void undeployingDeploymentHasBeenRedeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=220, value="Server shutdown has been requested.")
    public void shutdownHookInvoked();
}

