/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CleanObsoleteContentHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "clean-obsolete-content";
    private static final AttributeDefinition MARKED_CONTENT = ((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("marked-contents", ModelType.STRING).setAllowNull(true)).build();
    private static final AttributeDefinition DELETED_CONTENT = ((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("deleted-contents", ModelType.STRING).setAllowNull(true)).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("clean-obsolete-content", ServerDescriptions.getResourceDescriptionResolver("content")).setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{MARKED_CONTENT, DELETED_CONTENT}).build();
    private final ContentRepository contentRepository;

    public static CleanObsoleteContentHandler createOperation(ContentRepository contentRepository) {
        return new CleanObsoleteContentHandler(contentRepository);
    }

    private CleanObsoleteContentHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        Map obsoleteContents = this.contentRepository.cleanObsoleteContent();
        if (!((Set)obsoleteContents.get("marked-contents")).isEmpty()) {
            for (String obsoleteContent : (Set)obsoleteContents.get("marked-contents")) {
                context.getResult().get("marked-contents").add(obsoleteContent);
            }
        }
        if (!((Set)obsoleteContents.get("deleted-contents")).isEmpty()) {
            for (String obsoleteContent : (Set)obsoleteContents.get("deleted-contents")) {
                context.getResult().get("deleted-contents").add(obsoleteContent);
            }
        }
        context.stepCompleted();
    }
}

