/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.resource.InterfaceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SpecifiedInterfaceResolveHandler
implements OperationStepHandler {
    static final AttributeDefinition[] ATTRIBUTES = InterfaceDefinition.ROOT_ATTRIBUTES;
    private static final String OPERATION_NAME = "resolve-internet-address";
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("resolve-internet-address", ServerDescriptions.getResourceDescriptionResolver("interface")).setParameters(ATTRIBUTES).setReplyType(ModelType.STRING).setAttributeResolver(ControllerResolver.getResolver((String[])new String[]{"interface"})).withFlags(EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG).build();
    public static final SpecifiedInterfaceResolveHandler INSTANCE = new SpecifiedInterfaceResolveHandler();

    private SpecifiedInterfaceResolveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode config = new ModelNode();
        for (AttributeDefinition definition : ATTRIBUTES) {
            this.validateAndSet(definition, operation, config);
        }
        ParsedInterfaceCriteria parsed = ParsedInterfaceCriteria.parse((ModelNode)config, (boolean)true, (ExpressionResolver)context);
        if (parsed.getFailureMessage() != null) {
            throw new OperationFailedException(parsed.getFailureMessage());
        }
        try {
            NetworkInterfaceBinding nib = NetworkInterfaceService.createBinding(parsed);
            context.getResult().set(NetworkUtils.canonize((String)nib.getAddress().getHostAddress()));
        }
        catch (SocketException e) {
            throw ServerLogger.ROOT_LOGGER.cannotResolveInterface(e, e);
        }
        catch (UnknownHostException e) {
            throw ServerLogger.ROOT_LOGGER.cannotResolveInterface(e, e);
        }
        context.stepCompleted();
    }

    private void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.required(attributeName));
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalid(attributeName));
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }
}

